/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import java.util.NoSuchElementException;

public enum SourceType {
    DEFAULT("Default", 1, 2),
    ANALYSIS("Analysis", 2, 0),
    AI("AI", 2, 4),
    IMPORTED("Imported", 3, 3),
    USER_DEFINED("User Defined", 4, 1);

    private static SourceType[] SOURCE_BY_STORAGE_ID;
    private final String displayString;
    private final int storageId;
    private final int priority;

    private SourceType(String displayString, int priority, int storageId) {
        this.displayString = displayString;
        this.storageId = storageId;
        this.priority = priority;
    }

    public static SourceType getSourceType(int storageId) {
        try {
            SourceType source = SOURCE_BY_STORAGE_ID[storageId];
            if (source != null) {
                return source;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new NoSuchElementException("SourceType storgae ID not defined: " + storageId);
    }

    public int getPriority() {
        return this.priority;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public boolean isHigherPriorityThan(SourceType source) {
        return this.priority > source.priority;
    }

    public boolean isHigherOrEqualPriorityThan(SourceType source) {
        return this.priority >= source.priority;
    }

    public boolean isLowerPriorityThan(SourceType source) {
        return this.priority < source.priority;
    }

    public boolean isLowerOrEqualPriorityThan(SourceType source) {
        return this.priority <= source.priority;
    }

    static {
        SOURCE_BY_STORAGE_ID = new SourceType[]{ANALYSIS, USER_DEFINED, DEFAULT, IMPORTED, AI};
    }
}

