/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.Map;

public class ExtraStack
extends AssignAction {
    private ParamEntry stackEntry = null;
    private int afterBytes;
    private StorageClass afterStorage;

    private void initializeEntry() throws InvalidInputException {
        for (int i = 0; i < this.resource.getNumParamEntry(); ++i) {
            ParamEntry entry = this.resource.getEntry(i);
            if (entry.isExclusion() || !entry.getSpace().isStackSpace()) continue;
            this.stackEntry = entry;
            break;
        }
        if (this.stackEntry == null) {
            throw new InvalidInputException("Cannot find matching <pentry> for action: extra_stack");
        }
    }

    public ExtraStack(ParamListStandard res, int val) {
        super(res);
        this.afterStorage = StorageClass.GENERAL;
        this.afterBytes = -1;
    }

    public ExtraStack(StorageClass storage, int offset, ParamListStandard res) throws InvalidInputException {
        super(res);
        this.afterStorage = storage;
        this.afterBytes = offset;
        this.initializeEntry();
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) throws InvalidInputException {
        return new ExtraStack(this.afterStorage, this.afterBytes, newResource);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        ExtraStack otherAction = (ExtraStack)op;
        if (this.afterBytes != otherAction.afterBytes || this.afterStorage != otherAction.afterStorage) {
            return false;
        }
        return this.stackEntry.isEquivalent(otherAction.stackEntry);
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        if (res.address.getAddressSpace() == this.stackEntry.getSpace()) {
            return 0;
        }
        int grp = this.stackEntry.getGroup();
        if (this.afterBytes > 0) {
            int bytesConsumed = 0;
            for (int i = 0; i < this.resource.getNumParamEntry(); ++i) {
                if (i == grp || this.resource.getEntry(i).getType() != this.afterStorage || status[i] == 0) continue;
                bytesConsumed += this.resource.getEntry(i).getSize();
            }
            if (bytesConsumed < this.afterBytes) {
                return 0;
            }
        }
        ParameterPieces unused = new ParameterPieces();
        status[grp] = this.stackEntry.getAddrBySlot(status[grp], dt.getLength(), dt.getAlignment(), unused);
        return 0;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_EXTRA_STACK);
        if (this.afterBytes >= 0) {
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_AFTER_BYTES, this.afterBytes);
        }
        if (this.afterStorage != StorageClass.GENERAL) {
            encoder.writeString(AttributeId.ATTRIB_STORAGE, this.afterStorage.toString());
        }
        encoder.closeElement(ElementId.ELEM_EXTRA_STACK);
    }

    private void restoreAttributesXml(XmlElement el) throws XmlParseException {
        for (Map.Entry attrib : el.getAttributes().entrySet()) {
            String nm = (String)attrib.getKey();
            if (nm.equals(AttributeId.ATTRIB_AFTER_BYTES.name())) {
                this.afterBytes = SpecXmlUtils.decodeInt((String)((String)attrib.getValue()));
                continue;
            }
            if (!nm.equals(AttributeId.ATTRIB_AFTER_STORAGE.name())) continue;
            this.afterStorage = StorageClass.getClass((String)attrib.getValue());
        }
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_EXTRA_STACK.name()});
        this.restoreAttributesXml(elem);
        parser.end(elem);
        try {
            this.initializeEntry();
        }
        catch (InvalidInputException e) {
            throw new XmlParseException(e.getMessage());
        }
    }
}

