/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.ConstantValueSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.expression.BinaryExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import java.util.Map;
import java.util.Set;

public abstract class AbstractBinaryExpressionSolver<T extends BinaryExpression>
extends AbstractExpressionSolver<T> {
    public AbstractBinaryExpressionSolver(Class<T> tcls) {
        super(tcls);
    }

    @Override
    public AssemblyResolution solve(AbstractAssemblyResolutionFactory<?, ?> factory, T exp, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException {
        MaskedLong lval = this.solver.getValue(((BinaryExpression)exp).getLeft(), vals, cur);
        MaskedLong rval = this.solver.getValue(((BinaryExpression)exp).getRight(), vals, cur);
        if (lval != null && !lval.isFullyDefined()) {
            lval = null;
        }
        if (rval != null && !rval.isFullyDefined()) {
            rval = null;
        }
        try {
            if (lval != null && rval != null) {
                MaskedLong cval = this.compute(lval, rval);
                return ConstantValueSolver.checkConstAgrees(factory, cval, goal, description);
            }
            if (lval != null) {
                return this.solveRightSide(factory, ((BinaryExpression)exp).getRight(), lval, goal, vals, cur, hints, description);
            }
            if (rval != null) {
                return this.solveLeftSide(factory, ((BinaryExpression)exp).getLeft(), rval, goal, vals, cur, hints, description);
            }
            return this.solveTwoSided(factory, exp, goal, vals, cur, hints, description);
        }
        catch (NeedsBackfillException e) {
            throw e;
        }
        catch (SolverException e) {
            return ((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)factory.newErrorBuilder().error(e.getMessage()).description(description)).build();
        }
        catch (AssertionError e) {
            throw e;
        }
    }

    protected AssemblyResolution solveLeftSide(AbstractAssemblyResolutionFactory<?, ?> factory, PatternExpression lexp, MaskedLong rval, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException, SolverException {
        return this.solver.solve(factory, lexp, this.computeLeft(rval, goal), vals, cur, hints, description);
    }

    protected AssemblyResolution solveRightSide(AbstractAssemblyResolutionFactory<?, ?> factory, PatternExpression rexp, MaskedLong lval, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException, SolverException {
        return this.solver.solve(factory, rexp, this.computeRight(lval, goal), vals, cur, hints, description);
    }

    protected AssemblyResolution solveTwoSided(AbstractAssemblyResolutionFactory<?, ?> factory, T exp, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException, SolverException {
        throw new NeedsBackfillException("_two_sided_");
    }

    @Override
    public MaskedLong getValue(T exp, Map<String, Long> vals, AssemblyResolvedPatterns cur) throws NeedsBackfillException {
        MaskedLong lval = this.solver.getValue(((BinaryExpression)exp).getLeft(), vals, cur);
        MaskedLong rval = this.solver.getValue(((BinaryExpression)exp).getRight(), vals, cur);
        if (lval != null && rval != null) {
            MaskedLong cval = this.compute(lval, rval);
            return cval;
        }
        return null;
    }

    public abstract MaskedLong computeLeft(MaskedLong var1, MaskedLong var2) throws SolverException;

    public MaskedLong computeRight(MaskedLong lval, MaskedLong goal) throws SolverException {
        return this.computeLeft(lval, goal);
    }

    public abstract MaskedLong compute(MaskedLong var1, MaskedLong var2);

    @Override
    public int getInstructionLength(T exp) {
        int ll = this.solver.getInstructionLength(((BinaryExpression)exp).getLeft());
        int lr = this.solver.getInstructionLength(((BinaryExpression)exp).getRight());
        return Math.max(ll, lr);
    }

    @Override
    public MaskedLong valueForResolution(T exp, Map<String, Long> vals, AssemblyResolvedPatterns rc) {
        MaskedLong lval = this.solver.valueForResolution(((BinaryExpression)exp).getLeft(), vals, rc);
        MaskedLong rval = this.solver.valueForResolution(((BinaryExpression)exp).getRight(), vals, rc);
        return this.compute(lval, rval);
    }
}

