/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.util.bin.format.pdb.ApplyLineNumbers;
import ghidra.app.util.bin.format.pdb.ApplyStackVariables;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.bin.format.pdb.PdbUtil;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.List;

class ApplyFunctions {
    private ApplyFunctions() {
    }

    static void applyTo(PdbParser pdbParser, XmlPullParser xmlParser, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Program program = pdbParser.getProgram();
        Listing listing = program.getListing();
        while (xmlParser.hasNext()) {
            if (monitor.isCancelled()) {
                return;
            }
            XmlElement child = xmlParser.next();
            if (child.isEnd() && child.getName().equals("functions")) break;
            String name = child.getAttribute("name");
            int addr = XmlUtilities.parseInt((String)child.getAttribute("address"));
            Address address = PdbUtil.reladdr(program, addr);
            monitor.setMessage("Applying function at " + String.valueOf(address) + "...");
            Instruction instr = listing.getInstructionAt(address);
            if (instr == null) {
                DisassembleCommand cmd = new DisassembleCommand(address, null, true);
                cmd.applyTo(program, monitor);
            }
            pdbParser.createSymbol(address, name, true, log);
            Function function = listing.getFunctionAt(address);
            if (function == null) {
                function = ApplyFunctions.createFunction(program, address);
            }
            if (function == null) {
                function = ApplyFunctions.checkInsideThunkJump(program, address, monitor);
            }
            if (function == null) {
                function = ApplyFunctions.checkInsideThunkFunction(program, address, monitor);
            }
            if (function == null) {
                xmlParser.discardSubTree(child);
                continue;
            }
            ApplyStackVariables applyStackVariables = new ApplyStackVariables(pdbParser, xmlParser, function);
            applyStackVariables.applyTo(monitor, log);
            ApplyLineNumbers applyLineNumbers = new ApplyLineNumbers(pdbParser, xmlParser, program);
            applyLineNumbers.applyTo(monitor, log);
            xmlParser.next();
        }
    }

    private static Function checkInsideThunkFunction(Program program, Address address, TaskMonitor monitor) throws CancelledException {
        Listing listing = program.getListing();
        Function thunkFunction = listing.getFunctionContaining(address);
        if (thunkFunction == null) {
            return null;
        }
        if (thunkFunction.getEntryPoint().equals((Object)address)) {
            return null;
        }
        AddressSet thunkBody = new AddressSet(thunkFunction.getBody());
        boolean hasRangeMatch = false;
        AddressRangeIterator ari = thunkBody.getAddressRanges(true);
        while (ari.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            AddressRange range = (AddressRange)ari.next();
            if (!range.getMinAddress().equals((Object)address)) continue;
            hasRangeMatch = true;
            thunkBody.delete(range);
            break;
        }
        if (!hasRangeMatch) {
            return null;
        }
        try {
            thunkFunction.setBody((AddressSetView)thunkBody);
        }
        catch (OverlappingFunctionException range) {
            // empty catch block
        }
        Function newFunction = ApplyFunctions.createFunction(program, address);
        thunkFunction.setThunkedFunction(newFunction);
        return newFunction;
    }

    private static Function checkInsideThunkJump(Program program, Address address, TaskMonitor monitor) throws CancelledException {
        Listing listing = program.getListing();
        List<Reference> refList = ApplyFunctions.getReferencesTo(program, address, monitor);
        if (refList.size() != 1) {
            return null;
        }
        Address thunkAddress = refList.get(0).getFromAddress();
        Function thunkFunction = listing.getFunctionAt(thunkAddress);
        if (thunkFunction == null) {
            return null;
        }
        Instruction thunkInstr = listing.getInstructionAt(thunkAddress);
        if (thunkInstr.getFlowType().isJump()) {
            AddressSet newThunkBody = new AddressSet(thunkInstr.getMinAddress(), thunkInstr.getMaxAddress());
            try {
                thunkFunction.setBody((AddressSetView)newThunkBody);
            }
            catch (OverlappingFunctionException overlappingFunctionException) {
                // empty catch block
            }
        }
        Function newFunction = ApplyFunctions.createFunction(program, address);
        thunkFunction.setThunkedFunction(newFunction);
        return newFunction;
    }

    private static List<Reference> getReferencesTo(Program program, Address address, TaskMonitor monitor) throws CancelledException {
        ArrayList<Reference> refList = new ArrayList<Reference>();
        ReferenceManager refMgr = program.getReferenceManager();
        ReferenceIterator refIter = refMgr.getReferencesTo(address);
        while (refIter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            refList.add(refIter.next());
        }
        return refList;
    }

    private static Function createFunction(Program program, Address entryPoint) {
        CreateFunctionCmd fCmd = new CreateFunctionCmd(entryPoint);
        fCmd.applyTo((DomainObject)program);
        return program.getListing().getFunctionAt(entryPoint);
    }
}

