/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.border;

import com.jeta.forms.components.border.TitledBorderLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class TitledBorderLabelUI
extends ComponentUI {
    protected static final int VERTICAL_PADDING = 2;

    private boolean calcIntersection(Rectangle rectangle, int n, int n2, int n3, int n4) {
        int n5 = Math.max(n, rectangle.x);
        int n6 = Math.max(n2, rectangle.y);
        int n7 = Math.min(n + n3, rectangle.x + rectangle.width);
        int n8 = Math.min(n2 + n4, rectangle.y + rectangle.height);
        rectangle.setBounds(n5, n6, n7 - n5, n8 - n6);
        return rectangle.width > 0 && rectangle.height > 0;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        TitledBorderLabel titledBorderLabel;
        String string;
        if (jComponent instanceof TitledBorderLabel && (string = (titledBorderLabel = (TitledBorderLabel)jComponent).getText()) != null) {
            Font font = titledBorderLabel.getFont();
            FontMetrics fontMetrics = titledBorderLabel.getFontMetrics(font);
            int n = fontMetrics.getHeight() + 4;
            int n2 = fontMetrics.stringWidth(string) + 10;
            return new Dimension(n2, n);
        }
        return new Dimension(10, 10);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Border border = UIManager.getBorder("TitledBorder.border");
        if (jComponent instanceof TitledBorderLabel && border != null) {
            TitledBorderLabel titledBorderLabel = (TitledBorderLabel)jComponent;
            String string = titledBorderLabel.getText();
            if (string == null) {
                string = "";
            }
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            Font font = graphics.getFont();
            Color color = graphics.getColor();
            Insets insets = border.getBorderInsets(jComponent);
            graphics.setFont(titledBorderLabel.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = fontMetrics.stringWidth(string);
            int n4 = fontMetrics.getAscent() / 2 + 2;
            int n5 = n4 - fontMetrics.getDescent() + (insets.top + fontMetrics.getAscent() + fontMetrics.getDescent()) / 2;
            int n6 = 0;
            int n7 = titledBorderLabel.getTitleJustification();
            if (jComponent.getComponentOrientation().isLeftToRight()) {
                if (n7 == 5) {
                    n7 = 3;
                }
            } else if (n7 == 4 || n7 == 0) {
                n7 = 3;
            }
            n6 = n7 == 3 ? n - (n3 + insets.right + insets.left) : (n7 == 2 ? (n - n3) / 2 : insets.left);
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = graphics.getClipBounds();
            if (string.length() == 0) {
                border.paintBorder(jComponent, graphics, -12, n4, n + 24, n2 + 12);
            } else {
                rectangle.setBounds(rectangle2);
                if (this.calcIntersection(rectangle, 0, 0, n6 - 1, n2)) {
                    graphics.setClip(rectangle);
                    border.paintBorder(jComponent, graphics, -12, n4, n, n2 + 12);
                }
                rectangle.setBounds(rectangle2);
                if (this.calcIntersection(rectangle, n6 + n3 + 1, 0, n - (n6 + n3 + 1), n2)) {
                    graphics.setClip(rectangle);
                    border.paintBorder(jComponent, graphics, 0, n4, n + 12, n2 + 12);
                }
                graphics.setClip(rectangle2);
                graphics.setColor(titledBorderLabel.getTitleColor());
                graphics.drawString(string, n6, n5);
            }
            graphics.setFont(font);
            graphics.setColor(color);
        }
    }
}

