/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.panel;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.tabbedpane.DockingTabRenderer;
import generic.theme.GIcon;
import ghidra.features.base.codecompare.listing.ListingCodeComparisonView;
import ghidra.features.base.codecompare.panel.AddressSetComparisonData;
import ghidra.features.base.codecompare.panel.CodeComparisonView;
import ghidra.features.base.codecompare.panel.CodeComparisonViewState;
import ghidra.features.base.codecompare.panel.ComparisonData;
import ghidra.features.base.codecompare.panel.DataComparisonData;
import ghidra.features.base.codecompare.panel.FunctionComparisonData;
import ghidra.features.base.codecompare.panel.FunctionComparisonState;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.Duo;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FunctionComparisonPanel
extends JPanel
implements ChangeListener {
    private static final String ORIENTATION_PROPERTY_NAME = "ORIENTATION";
    private static final String DEFAULT_CODE_COMPARISON_VIEW = "Listing View";
    private static final String COMPARISON_VIEW_DISPLAYED = "COMPARISON_VIEW_DISPLAYED";
    private static final String CODE_COMPARISON_LOCK_SCROLLING_TOGETHER = "CODE_COMPARISON_LOCK_SCROLLING_TOGETHER";
    private static final String HELP_TOPIC = "FunctionComparison";
    private static final Icon SYNC_SCROLLING_ICON = new GIcon("icon.plugin.functioncompare.scroll.lock");
    private static final Icon UNSYNC_SCROLLING_ICON = new GIcon("icon.plugin.functioncompare.scroll.unlock");
    private static final String SCROLLING_GROUP = "A9_SCROLLING";
    private static final String DUAL_SCROLLING_ACTION_GROUP = "DualScrolling";
    private static final String DUAL_SCROLLING_HELP_TOPIC = "FunctionComparison";
    private JTabbedPane tabbedPane;
    private Map<String, JComponent> tabNameToComponentMap;
    private List<CodeComparisonView> codeComparisonViews;
    private ToggleScrollLockAction toggleScrollLockAction;
    private boolean syncScrolling = false;
    private Duo<ComparisonData> comparisonData = new Duo((Object)ComparisonData.EMPTY, (Object)ComparisonData.EMPTY);
    private FunctionComparisonState state;

    public FunctionComparisonPanel(PluginTool tool, String owner, FunctionComparisonState state) {
        this.state = state;
        state.addUpdateCallback(this::comparisonStateUpdated);
        this.codeComparisonViews = this.getCodeComparisonViews(tool, owner);
        this.tabNameToComponentMap = new HashMap<String, JComponent>();
        this.createMainPanel();
        this.createActions(owner);
        this.setScrollingSyncState(true);
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this, new HelpLocation("FunctionComparison", "Function Comparison"));
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(50, 50);
    }

    private void comparisonStateUpdated() {
        this.readPanelState();
        this.readViewState();
    }

    public void loadFunctions(Function leftFunction, Function rightFunction) {
        ComparisonData left = leftFunction == null ? ComparisonData.EMPTY : new FunctionComparisonData(leftFunction);
        ComparisonData right = rightFunction == null ? ComparisonData.EMPTY : new FunctionComparisonData(rightFunction);
        this.loadComparisons(left, right);
    }

    public void loadData(Data leftData, Data rightData) {
        DataComparisonData left = new DataComparisonData(leftData, rightData.getLength());
        DataComparisonData right = new DataComparisonData(rightData, leftData.getLength());
        this.loadComparisons(left, right);
    }

    public void loadComparisons(ComparisonData left, ComparisonData right) {
        this.comparisonData = new Duo((Object)left, (Object)right);
        CodeComparisonView activeView = this.getActiveComparisonView();
        if (activeView != null) {
            activeView.loadComparisons(left, right);
        }
    }

    public void loadAddresses(Program leftProgram, Program rightProgram, AddressSetView leftAddresses, AddressSetView rightAddresses) {
        AddressSetComparisonData left = new AddressSetComparisonData(leftProgram, leftAddresses);
        AddressSetComparisonData right = new AddressSetComparisonData(rightProgram, rightAddresses);
        this.loadComparisons(left, right);
    }

    public DockingAction[] getActions() {
        DockingAction[] actions = new DockingAction[]{this.toggleScrollLockAction};
        return actions;
    }

    public String getDescription() {
        String leftShort = ((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).getShortDescription();
        String rightShort = ((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).getShortDescription();
        return leftShort + " & " + rightShort;
    }

    public void clear() {
        this.comparisonData = new Duo((Object)ComparisonData.EMPTY, (Object)ComparisonData.EMPTY);
        CodeComparisonView activeView = this.getActiveComparisonView();
        if (activeView != null) {
            activeView.clearComparisons();
        }
    }

    public boolean isEmpty() {
        return ((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).isEmpty() || ((ComparisonData)this.comparisonData.get(Duo.Side.RIGHT)).isEmpty();
    }

    public ListingCodeComparisonView getDualListingView() {
        for (CodeComparisonView view : this.codeComparisonViews) {
            if (!(view instanceof ListingCodeComparisonView)) continue;
            ListingCodeComparisonView listingView = (ListingCodeComparisonView)view;
            return listingView;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.tabChanged();
        this.writeTabState();
    }

    public boolean setCurrentTabbedComponent(String name) {
        JComponent component = this.tabNameToComponentMap.get(name);
        if (component != null) {
            if (this.tabbedPane.getSelectedComponent() == component) {
                this.tabChanged();
            }
            this.tabbedPane.setSelectedComponent(component);
        }
        return component != null;
    }

    public String getCurrentComponentName() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex >= 0) {
            return this.tabbedPane.getTitleAt(selectedIndex);
        }
        return null;
    }

    int getNumberOfTabbedComponents() {
        return this.tabNameToComponentMap.size();
    }

    public void dispose() {
        this.tabbedPane.removeAll();
        this.setVisible(false);
        for (CodeComparisonView view : this.codeComparisonViews) {
            view.dispose();
        }
    }

    public void programClosed(Program program) {
        for (CodeComparisonView view : this.codeComparisonViews) {
            view.programClosed(program);
        }
    }

    public CodeComparisonView getCodeComparisonView(String name) {
        for (CodeComparisonView view : this.codeComparisonViews) {
            if (!name.equals(view.getName())) continue;
            return view;
        }
        return null;
    }

    public void selectComparisonView(String name) {
        for (CodeComparisonView view : this.codeComparisonViews) {
            if (!name.equals(view.getName())) continue;
            this.tabbedPane.setSelectedComponent(view);
        }
    }

    private void createMainPanel() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.setPreferredSize(new Dimension(200, 300));
        for (CodeComparisonView view : this.codeComparisonViews) {
            this.tabbedPane.add(view.getName(), view);
            this.tabNameToComponentMap.put(view.getName(), view);
        }
    }

    private void tabChanged() {
        CodeComparisonView activeView = this.getActiveComparisonView();
        if (activeView == null) {
            return;
        }
        activeView.loadComparisons((ComparisonData)this.comparisonData.get(Duo.Side.LEFT), (ComparisonData)this.comparisonData.get(Duo.Side.RIGHT));
    }

    private CodeComparisonView getActiveComparisonView() {
        return (CodeComparisonView)this.tabbedPane.getSelectedComponent();
    }

    private void readViewState() {
        CodeComparisonViewState viewState = this.state.getViewState();
        this.codeComparisonViews.forEach(v -> {
            Class<?> viewClass = v.getClass();
            SaveState saveState = viewState.getSaveState(viewClass);
            v.setSaveState(saveState);
        });
    }

    private void readPanelState() {
        SaveState panelState = this.state.getPanelState();
        String currentTabView = panelState.getString(COMPARISON_VIEW_DISPLAYED, DEFAULT_CODE_COMPARISON_VIEW);
        this.setCurrentTabbedComponent(currentTabView);
        this.setScrollingSyncState(panelState.getBoolean(CODE_COMPARISON_LOCK_SCROLLING_TOGETHER, true));
        for (CodeComparisonView view : this.codeComparisonViews) {
            String key = view.getName() + ORIENTATION_PROPERTY_NAME;
            view.setSideBySide(panelState.getBoolean(key, true));
        }
    }

    private void writeTabState() {
        String currentComponentName = this.getCurrentComponentName();
        if (currentComponentName == null) {
            return;
        }
        SaveState panelState = this.state.getPanelState();
        panelState.putString(COMPARISON_VIEW_DISPLAYED, this.getCurrentComponentName());
        this.state.setChanged();
    }

    private void writeScrollState() {
        SaveState panelState = this.state.getPanelState();
        panelState.putBoolean(CODE_COMPARISON_LOCK_SCROLLING_TOGETHER, this.isScrollingSynced());
        this.state.setChanged();
    }

    private void writeOrientationState() {
        SaveState panelState = this.state.getPanelState();
        for (CodeComparisonView view : this.codeComparisonViews) {
            String key = view.getName() + ORIENTATION_PROPERTY_NAME;
            boolean sideBySide = view.isSideBySide();
            panelState.putBoolean(key, sideBySide);
        }
    }

    public DockingAction[] getCodeComparisonActions() {
        ArrayList<DockingAction> dockingActionList = new ArrayList<DockingAction>();
        DockingAction[] actions = this.getActions();
        for (DockingAction action : actions) {
            dockingActionList.add(action);
        }
        for (CodeComparisonView view : this.codeComparisonViews) {
            dockingActionList.addAll(view.getActions());
        }
        return dockingActionList.toArray(new DockingAction[dockingActionList.size()]);
    }

    public void setTitlePrefixes(String leftTitlePrefix, String rightTitlePrefix) {
        Component[] components;
        for (Component component : components = this.tabbedPane.getComponents()) {
            if (!(component instanceof CodeComparisonView)) continue;
            ((CodeComparisonView)component).setTitlePrefixes(leftTitlePrefix, rightTitlePrefix);
        }
    }

    public ActionContext getActionContext(MouseEvent event, ComponentProvider componentProvider) {
        CodeComparisonView activeProvider = this.getDisplayedView();
        if (activeProvider != null) {
            return activeProvider.getActionContext(componentProvider, event);
        }
        return null;
    }

    public final boolean isScrollingSynced() {
        return this.syncScrolling;
    }

    public void setScrollingSyncState(boolean syncScrolling) {
        if (this.isScrollingSynced() == syncScrolling) {
            return;
        }
        this.toggleScrollLockAction.setSelected(syncScrolling);
        this.toggleScrollLockAction.setToolBarData(new ToolBarData(syncScrolling ? SYNC_SCROLLING_ICON : UNSYNC_SCROLLING_ICON, SCROLLING_GROUP));
        for (CodeComparisonView view : this.codeComparisonViews) {
            view.setSynchronizedScrolling(syncScrolling);
        }
        this.syncScrolling = syncScrolling;
        this.writeScrollState();
    }

    public CodeComparisonView getDisplayedView() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        Component component = this.tabbedPane.getComponentAt(selectedIndex);
        return (CodeComparisonView)component;
    }

    public void updateActionEnablement() {
        for (CodeComparisonView view : this.codeComparisonViews) {
            view.updateActionEnablement();
        }
    }

    public CodeComparisonView getCurrentView() {
        return (CodeComparisonView)this.tabbedPane.getSelectedComponent();
    }

    boolean isTabClick(MouseEvent event) {
        Component component = event.getComponent();
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            DockingTabRenderer renderer = (DockingTabRenderer)this.tabbedPane.getTabComponentAt(i);
            if (!SwingUtilities.isDescendingFrom(component, (Component)renderer)) continue;
            return true;
        }
        return false;
    }

    private void createActions(String owner) {
        this.toggleScrollLockAction = new ToggleScrollLockAction(owner);
    }

    public List<CodeComparisonView> getComparisonView() {
        return this.codeComparisonViews;
    }

    private List<CodeComparisonView> getCodeComparisonViews(PluginTool tool, String owner) {
        if (this.codeComparisonViews == null) {
            this.codeComparisonViews = this.createAllCodeComparisonViews(tool, owner);
            this.codeComparisonViews.sort((p1, p2) -> p1.getName().compareTo(p2.getName()));
        }
        return this.codeComparisonViews;
    }

    private List<CodeComparisonView> createAllCodeComparisonViews(PluginTool tool, String owner) {
        CodeComparisonViewState viewState = this.state.getViewState();
        ArrayList<CodeComparisonView> instances = new ArrayList<CodeComparisonView>();
        List classes = ClassSearcher.getClasses(CodeComparisonView.class);
        for (Class viewClass : classes) {
            try {
                Constructor constructor = viewClass.getConstructor(String.class, PluginTool.class);
                CodeComparisonView view = (CodeComparisonView)constructor.newInstance(owner, tool);
                SaveState saveState = viewState.getSaveState(viewClass);
                view.setSaveState(saveState);
                view.setOrientationChangedCallback(() -> this.writeOrientationState());
                instances.add(view);
            }
            catch (Exception e) {
                Msg.showError((Object)this, null, (String)"Error Creating Extension Point", (Object)("Error creating class " + viewClass.getName() + " when creating extension points for " + CodeComparisonView.class.getName()), (Throwable)e);
            }
        }
        return instances;
    }

    private class ToggleScrollLockAction
    extends ToggleDockingAction {
        ToggleScrollLockAction(String owner) {
            super("Synchronize Scrolling of Dual View", owner);
            this.setDescription("Lock/Unlock Synchronized Scrolling of Dual View");
            this.setToolBarData(new ToolBarData(UNSYNC_SCROLLING_ICON, FunctionComparisonPanel.SCROLLING_GROUP));
            this.setEnabled(true);
            MenuData menuData = new MenuData(new String[]{"Synchronize Scrolling"}, FunctionComparisonPanel.DUAL_SCROLLING_ACTION_GROUP);
            this.setMenuBarData(menuData);
            this.setHelpLocation(new HelpLocation("FunctionComparison", "Synchronize Scrolling of Dual View"));
        }

        public void actionPerformed(ActionContext context) {
            FunctionComparisonPanel.this.setScrollingSyncState(this.isSelected());
        }
    }
}

