/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.streams;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeMarkupable;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.cli.CliStreamHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public abstract class CliAbstractStream
implements StructConverter,
PeMarkupable {
    public static final String PATH = "/PE/CLI/Streams";
    protected CliStreamHeader header;
    protected long offset;
    protected int rva;
    protected BinaryReader reader;

    public CliAbstractStream(CliStreamHeader header, long offset, int rva, BinaryReader reader) throws IOException {
        this.header = header;
        this.offset = offset;
        this.rva = rva;
        this.reader = reader;
    }

    public abstract boolean parse() throws IOException;

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, IOException {
        monitor.setMessage("[" + program.getName() + "]: CLI stream...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.rva);
        program.getBookmarkManager().setBookmark(addr, "Info", "CLI Stream", this.header.getName());
        try {
            program.getSymbolTable().createLabel(addr, "CLI_Stream_" + this.header.getName(), SourceType.ANALYSIS);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Error marking up CLI stream \"" + this.header.getName() + "\""), (Throwable)e);
            return;
        }
        if (!program.getMemory().contains(addr)) {
            return;
        }
        DataType dt = this.toDataType();
        dt.setCategoryPath(new CategoryPath(PATH));
        PeUtils.createData(program, addr, dt, log);
    }

    public CliStreamHeader getStreamHeader() {
        return this.header;
    }

    public static Address getStreamMarkupAddress(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader, CliAbstractStream stream, int streamIndex) {
        CliStreamHeader streamHeader = stream.getStreamHeader();
        return PeUtils.getMarkupAddress(program, isBinary, ntHeader, streamHeader.getMetadataRoot().getRva() + streamHeader.getOffset() + streamIndex);
    }
}

