/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.dyld.DyldChainedPtr;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldChainedStartsOffsets
implements StructConverter {
    private int pointerFormat;
    private int startsCount;
    private int[] chainStarts;

    public DyldChainedStartsOffsets(BinaryReader reader) throws IOException {
        this.pointerFormat = reader.readNextInt();
        this.startsCount = reader.readNextInt();
        this.chainStarts = reader.readNextIntArray(this.startsCount);
    }

    public DyldChainedPtr.DyldChainType getPointerFormat() {
        return DyldChainedPtr.DyldChainType.lookupChainPtr(this.pointerFormat);
    }

    public int getStartsCount() {
        return this.startsCount;
    }

    public int[] getChainStartOffsets() {
        return this.chainStarts;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_chained_starts_offset", 0);
        struct.add(DWORD, "pointer_format", "DYLD_CHAINED_PTR_*");
        struct.add(DWORD, "starts_count", "number of starts in array");
        struct.add((DataType)new ArrayDataType(IBO32, this.startsCount, 1), "chain_starts", "array chain start offsets");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

