/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import ghidra.app.plugin.core.function.SharedReturnAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class SharedReturnJumpAnalyzer
extends SharedReturnAnalyzer {
    private static final String NAME = "Shared Return Calls";
    private static final int NOTIFICATION_INTERVAL = 4096;

    public SharedReturnJumpAnalyzer() {
        super(NAME, "Converts branches to calls, followed by an immediate return, when the destination is a function.  Since this analysis is triggered by the creation of the destination function, the one-shot analysis action can be used if functions were created while this analyzer was disabled or not present.", AnalyzerType.INSTRUCTION_ANALYZER);
        this.setPriority(AnalysisPriority.CODE_ANALYSIS.before().before());
        this.setSupportsOneTimeAnalysis(false);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        ReferenceManager mgr = program.getReferenceManager();
        Listing listing = program.getListing();
        AddressSet sharedReturnSet = new AddressSet();
        int count = 0;
        long initial_count = set.getNumAddresses();
        monitor.initialize(initial_count);
        AddressSet leftSet = new AddressSet(set);
        AddressIterator iter = mgr.getReferenceSourceIterator(set, true);
        while (iter.hasNext()) {
            FlowType flowType;
            Instruction instr;
            monitor.checkCancelled();
            Address addr = iter.next();
            if (++count > 4096) {
                leftSet.deleteRange(leftSet.getMinAddress(), addr);
                monitor.setProgress(initial_count - leftSet.getNumAddresses());
                monitor.setMessage("Find Shared Return : " + String.valueOf(addr));
                count = 0;
            }
            if ((instr = listing.getInstructionAt(addr)) == null || !(flowType = instr.getFlowType()).isJump()) continue;
            Reference[] refs = mgr.getFlowReferencesFrom(addr);
            for (int refIndex = 0; refIndex < refs.length; ++refIndex) {
                Reference ref = refs[refIndex];
                RefType refType = ref.getReferenceType();
                if (!refType.isJump()) continue;
                Address entryAddr = ref.getToAddress();
                Function funcAt = program.getFunctionManager().getFunctionAt(entryAddr);
                if (funcAt == null) continue;
                sharedReturnSet.addRange(entryAddr, entryAddr);
            }
        }
        return super.added(program, (AddressSetView)sharedReturnSet, monitor, log);
    }
}

