/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.editor;

import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.TableSortState;
import ghidra.app.plugin.core.datamgr.editor.EnumEditorPanel;
import ghidra.app.plugin.core.datamgr.editor.EnumEntry;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.NumericUtilities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;

class EnumTableModel
extends AbstractSortedTableModel<EnumEntry> {
    static final int NAME_COL = 0;
    static final int VALUE_COL = 1;
    static final int COMMENT_COL = 2;
    static final String NAME = "Name";
    static final String VALUE = "Value";
    static final String COMMENT = "Comment";
    private static String[] columnNames = new String[]{"Name", "Value", "Comment"};
    private EnumDataType enuum;
    private List<EnumEntry> enumEntryList;
    private boolean isChanged;
    private EnumEditorPanel editorPanel;

    EnumTableModel(EnumDataType enuum, EnumEditorPanel editorPanel) {
        super(1);
        this.enuum = enuum;
        this.editorPanel = editorPanel;
        this.initialize();
    }

    public String getName() {
        return "Enum Editor";
    }

    public int getRowCount() {
        return this.enuum.getCount();
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return Long.class;
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public Object getColumnValueForRow(EnumEntry v, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return v.getName();
            }
            case 1: {
                return v.getValue();
            }
            case 2: {
                return v.getComment();
            }
        }
        return null;
    }

    public List<EnumEntry> getModelData() {
        return this.enumEntryList;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int size = this.enumEntryList.size();
        if (rowIndex < 0 || rowIndex >= size) {
            return;
        }
        boolean notifyListener = false;
        EnumEntry entry = this.enumEntryList.get(rowIndex);
        Long oldValue = entry.getValue();
        String oldName = entry.getName();
        String oldComment = entry.getComment();
        switch (columnIndex) {
            case 0: {
                String newName = (String)aValue;
                if (oldName.equals(newName) || !this.isNameValid(newName)) break;
                this.enuum.remove(oldName);
                this.enuum.add(newName, oldValue.longValue(), oldComment);
                entry.setName(newName);
                notifyListener = true;
                break;
            }
            case 1: {
                try {
                    if ("".equals(aValue)) {
                        return;
                    }
                    Long newValue = NumericUtilities.parseLong((String)((String)aValue));
                    if (oldValue.equals(newValue)) break;
                    this.enuum.remove(oldName);
                    try {
                        this.enuum.add(oldName, newValue.longValue(), oldComment);
                        entry.setValue(newValue);
                        notifyListener = true;
                    }
                    catch (IllegalArgumentException e) {
                        this.enuum.add(oldName, oldValue.longValue(), oldComment);
                        this.editorPanel.setStatusMessage(e.getMessage());
                    }
                }
                catch (NumberFormatException e) {
                    this.editorPanel.setStatusMessage("Invalid number entered");
                }
                break;
            }
            case 2: {
                String newComment = (String)aValue;
                if (oldComment.equals(newComment) || newComment == null) break;
                this.enuum.remove(oldName);
                this.enuum.add(oldName, oldValue.longValue(), newComment);
                entry.setComment(newComment);
                notifyListener = true;
            }
        }
        if (notifyListener) {
            this.editorPanel.stateChanged(null);
            this.isChanged = true;
            this.editorPanel.restoreSelection(oldName, true);
        } else {
            this.editorPanel.restoreSelection(oldName, false);
        }
    }

    public String getColumnName(int column) {
        return columnNames[column];
    }

    public void setTableSortState(TableSortState sortState) {
        this.editorPanel.stopCellEditing();
        super.setTableSortState(sortState);
    }

    protected Comparator<EnumEntry> createSortComparator(int columnIndex) {
        if (columnIndex == 0) {
            return new EnumNameComparator(this);
        }
        if (columnIndex == 1) {
            return new EnumValueComparator(this);
        }
        if (columnIndex == 2) {
            return new EnumCommentComparator(this);
        }
        return null;
    }

    EnumDataType getEnum() {
        return this.enuum;
    }

    boolean hasChanges() {
        return this.isChanged;
    }

    public void dispose() {
        super.dispose();
        this.isChanged = false;
        this.enumEntryList.clear();
    }

    int getRow(String name) {
        for (int i = 0; i < this.enumEntryList.size(); ++i) {
            if (!this.enumEntryList.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    String getNameAt(int index) {
        return this.enumEntryList.get(index).getName();
    }

    void setEnum(EnumDataType enuum, boolean isChanged) {
        this.enuum = enuum;
        this.isChanged = isChanged;
        this.initialize();
    }

    int addEntry(int afterRow) {
        Long value = this.findNextValue(afterRow);
        String name = this.getUniqueName();
        String comment = "";
        EnumEntry newEntry = new EnumEntry(name, value, comment);
        try {
            this.enuum.add(name, value.longValue(), comment);
            int index = this.getIndexForRowObject(newEntry);
            if (index < 0) {
                index = -index - 1;
            }
            this.enumEntryList.add(newEntry);
            this.fireTableDataChanged();
            this.isChanged = true;
            return index;
        }
        catch (IllegalArgumentException e) {
            this.editorPanel.setStatusMessage(e.getMessage());
            return -1;
        }
    }

    private long findNextValue(int afterRow) {
        boolean wrapOK;
        long value;
        if (this.enumEntryList.isEmpty()) {
            return 0L;
        }
        if (afterRow < 0 || afterRow >= this.enumEntryList.size()) {
            afterRow = 0;
        }
        if (!this.isValidValue(value = this.enumEntryList.get(afterRow).getValue() + 1L)) {
            value = 0L;
        }
        boolean bl = wrapOK = value != 0L;
        while (this.enuum.getName(value) != null) {
            if (this.isValidValue(++value)) continue;
            if (!wrapOK) break;
            value = 0L;
            wrapOK = false;
        }
        return value;
    }

    private boolean isValidValue(long value) {
        long min = this.enuum.getMinPossibleValue();
        long max = this.enuum.getMaxPossibleValue();
        return value >= min && value <= max;
    }

    private String getUniqueName() {
        Object name = "New_Name";
        int count = 0;
        while (this.enumContainsName((String)name)) {
            name = "New_Name_(" + ++count + ")";
        }
        return name;
    }

    private void initialize() {
        String[] names;
        this.enumEntryList = new ArrayList<EnumEntry>();
        for (String name : names = this.enuum.getNames()) {
            this.enumEntryList.add(new EnumEntry(name, this.enuum.getValue(name), this.enuum.getComment(name)));
        }
        this.fireTableDataChanged();
    }

    private boolean isNameValid(String name) {
        if (name == null || name.length() == 0) {
            this.editorPanel.setStatusMessage("Please enter a name");
            return false;
        }
        if (this.enumContainsName(name)) {
            this.editorPanel.setStatusMessage(name + " already exists");
            return false;
        }
        return true;
    }

    private boolean enumContainsName(String name) {
        try {
            this.enuum.getValue(name);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public void setLength(int length) {
        this.enuum.setLength(length);
        if (this.getRowCount() > 0) {
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        }
    }

    private class EnumNameComparator
    implements Comparator<EnumEntry> {
        private EnumNameComparator(EnumTableModel enumTableModel) {
        }

        @Override
        public int compare(EnumEntry entry1, EnumEntry entry2) {
            return entry1.getName().compareTo(entry2.getName());
        }
    }

    private class EnumValueComparator
    implements Comparator<EnumEntry> {
        private EnumValueComparator(EnumTableModel enumTableModel) {
        }

        @Override
        public int compare(EnumEntry entry1, EnumEntry entry2) {
            return Long.valueOf(entry1.getValue()).compareTo(entry2.getValue());
        }
    }

    private class EnumCommentComparator
    implements Comparator<EnumEntry> {
        private EnumCommentComparator(EnumTableModel enumTableModel) {
        }

        @Override
        public int compare(EnumEntry entry1, EnumEntry entry2) {
            return StringUtils.compare((String)entry1.getComment(), (String)entry2.getComment());
        }
    }
}

