/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.actions;

import docking.action.MenuData;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.context.ProgramLocationContextAction;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Data;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskLauncher;

public class ExpandAllDataAction
extends ProgramLocationContextAction {
    private CodeViewerProvider provider;

    public ExpandAllDataAction(CodeViewerProvider provider) {
        super("Expand All Data", provider.getOwner());
        this.provider = provider;
        this.setPopupMenuData(new MenuData(new String[]{"Data", "Expand All Data"}, null, "BasicData2"));
        this.setDescription("Open all data recursively from the current location downward.");
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "ExpandCollapseActions"));
        this.setEnabled(true);
        this.addToWindowWhen(ProgramLocationActionContext.class);
    }

    @Override
    protected boolean isEnabledForContext(ProgramLocationActionContext context) {
        if (context.getSelection() != null && !context.getSelection().isEmpty()) {
            this.updatePopupMenuName(true);
            return true;
        }
        Data componentData = this.getComponentData(context.getLocation());
        if (componentData == null) {
            return false;
        }
        this.updatePopupMenuName(false);
        return true;
    }

    @Override
    protected void actionPerformed(ProgramLocationActionContext context) {
        ListingModel model = this.getModel();
        ProgramSelection selection = context.getSelection();
        if (selection != null && !selection.isEmpty()) {
            TaskLauncher.launchModal((String)"Expand Data In Selection", monitor -> model.openAllData(selection, monitor));
            return;
        }
        ProgramLocation location = context.getLocation();
        Data data = this.getComponentData(location);
        TaskLauncher.launchModal((String)"Expand Data In Selection", monitor -> model.openAllData(data, monitor));
    }

    private void updatePopupMenuName(boolean hasSelection) {
        if (hasSelection) {
            this.getPopupMenuData().setMenuPath(new String[]{"Data", "Expand All Data In Selection"});
            this.setDescription("Open all data recursively in the current selection.");
        } else {
            this.getPopupMenuData().setMenuPath(new String[]{"Data", "Expand All Data"});
            this.setDescription("Open all data recursively from the current location downward.");
        }
    }

    private ListingModel getModel() {
        ListingPanel listingPanel = this.provider.getListingPanel();
        return listingPanel.getListingModel();
    }

    private Data getComponentData(ProgramLocation location) {
        if (location == null) {
            return null;
        }
        Data data = DataUtilities.getDataAtLocation((ProgramLocation)location);
        if (data == null || data.getNumComponents() <= 0) {
            return null;
        }
        return data;
    }
}

