/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.AddressIteratorAdapter;
import ghidra.util.AddressRangeIterators;
import ghidra.util.DifferenceAddressSetView;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.SymmetricDifferenceAddressSetView;
import ghidra.util.UnionAddressSetView;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractAddressSetView
implements AddressSetView {
    protected static Address fixStart(AddressRangeIterator rev, Address start, boolean forward) {
        if (!rev.hasNext()) {
            return start;
        }
        AddressRange rng = (AddressRange)rev.next();
        if (!rng.contains(start)) {
            return start;
        }
        return forward ? rng.getMinAddress() : rng.getMaxAddress();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public boolean contains(Address start, Address end) {
        AddressRangeIterator dit = AddressRangeIterators.subtract(new AddressSet(start, end).iterator(), this.iterator(start, true), null, true);
        return !dit.hasNext();
    }

    @Override
    public boolean contains(AddressSetView rangeSet) {
        AddressRangeIterator dit = AddressRangeIterators.subtract(rangeSet.iterator(), this.iterator(rangeSet.getMinAddress(), true), null, true);
        return !dit.hasNext();
    }

    @Override
    public Address getMinAddress() {
        AddressRangeIterator it = this.getAddressRanges(true);
        return it.hasNext() ? ((AddressRange)it.next()).getMinAddress() : null;
    }

    @Override
    public Address getMaxAddress() {
        AddressRangeIterator it = this.getAddressRanges(false);
        return it.hasNext() ? ((AddressRange)it.next()).getMaxAddress() : null;
    }

    @Override
    public int getNumAddressRanges() {
        int count = 0;
        for (AddressRange r : this) {
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this.getAddressRanges();
    }

    @Override
    public Iterator<AddressRange> iterator(boolean forward) {
        return this.getAddressRanges(forward);
    }

    @Override
    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.getAddressRanges(start, forward);
    }

    @Override
    public long getNumAddresses() {
        long count = 0L;
        for (AddressRange r : this) {
            count += r.getLength();
        }
        return count;
    }

    @Override
    public AddressIterator getAddresses(boolean forward) {
        return new AddressIteratorAdapter(this.iterator(forward), forward);
    }

    @Override
    public AddressIterator getAddresses(Address start, boolean forward) {
        return new AddressIteratorAdapter(this.iterator(start, forward), start, forward);
    }

    @Override
    public boolean hasSameAddresses(AddressSetView view) {
        AddressRangeIterator ait = this.getAddressRanges();
        AddressRangeIterator bit = view.getAddressRanges();
        while (ait.hasNext() && bit.hasNext()) {
            AddressRange br;
            AddressRange ar = (AddressRange)ait.next();
            if (ar.equals(br = (AddressRange)bit.next())) continue;
            return false;
        }
        return !ait.hasNext() && !bit.hasNext();
    }

    @Override
    public AddressRange getFirstRange() {
        Iterator<AddressRange> it = this.iterator(true);
        return it.hasNext() ? it.next() : null;
    }

    @Override
    public AddressRange getLastRange() {
        Iterator<AddressRange> it = this.iterator(false);
        return it.hasNext() ? it.next() : null;
    }

    @Override
    public boolean intersects(AddressSetView addrSet) {
        AddressRangeIterator iit = AddressRangeIterators.intersect(this.iterator(addrSet.getMinAddress(), true), addrSet.iterator(this.getMinAddress(), true), true);
        return iit.hasNext();
    }

    @Override
    public boolean intersects(Address start, Address end) {
        AddressRangeIterator iit = AddressRangeIterators.intersect(this.iterator(start, true), List.of(new AddressRangeImpl(start, end)).iterator(), true);
        return iit.hasNext();
    }

    @Override
    public AddressSet intersect(AddressSetView view) {
        return new AddressSet(new IntersectionAddressSetView(this, view));
    }

    @Override
    public AddressSet intersectRange(Address start, Address end) {
        return this.intersect(new AddressSet(start, end));
    }

    @Override
    public AddressSet union(AddressSetView addrSet) {
        return new AddressSet(new UnionAddressSetView(this, addrSet));
    }

    @Override
    public AddressSet subtract(AddressSetView addrSet) {
        return new AddressSet(new DifferenceAddressSetView(this, addrSet));
    }

    @Override
    public AddressSet xor(AddressSetView addrSet) {
        return new AddressSet(new SymmetricDifferenceAddressSetView(this, addrSet));
    }

    @Override
    public Address findFirstAddressInCommon(AddressSetView set) {
        AddressRangeIterator iit = AddressRangeIterators.intersect(this.iterator(), set.iterator(), true);
        return iit.hasNext() ? ((AddressRange)iit.next()).getMinAddress() : null;
    }

    @Override
    public AddressRange getRangeContaining(Address address) {
        AddressRangeIterator it = this.getAddressRanges(address, true);
        if (!it.hasNext()) {
            return null;
        }
        AddressRange rng = (AddressRange)it.next();
        if (!rng.contains(address)) {
            return null;
        }
        return rng;
    }
}

