/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.SimpleDiffUtility;

public class VariableLocation
extends FunctionLocation {
    private boolean isParameter;
    private int ordinalOrfirstUseOffset;
    private Address variableAddress;

    @Override
    public String toString() {
        return super.toString() + ", isParameter = " + this.isParameter + ", ordinalOrfirstUseOffset = " + this.ordinalOrfirstUseOffset + ", Variable Address = " + String.valueOf(this.variableAddress);
    }

    public VariableLocation() {
    }

    public VariableLocation(Program program, Address locationAddr, Variable var, int index, int charOffset) {
        super(program, locationAddr, var.getFunction().getEntryPoint(), 0, index, charOffset);
        this.variableAddress = this.getVariableAddress(var);
        if (var instanceof Parameter) {
            this.isParameter = true;
            this.ordinalOrfirstUseOffset = ((Parameter)var).getOrdinal();
        } else {
            this.ordinalOrfirstUseOffset = var.getFirstUseOffset();
        }
    }

    public VariableLocation(Program program, Variable var, int index, int charOffset) {
        this(program, var.getFunction().getEntryPoint(), var, index, charOffset);
    }

    public Variable getVariable() {
        Function function = this.program.getFunctionManager().getFunctionAt(this.functionAddr);
        if (function == null) {
            return null;
        }
        if (this.isParameter) {
            return function.getParameter(this.ordinalOrfirstUseOffset);
        }
        if (this.variableAddress == null || !this.variableAddress.isVariableAddress()) {
            return null;
        }
        for (Variable var : function.getLocalVariables()) {
            if (var.getFirstUseOffset() != this.ordinalOrfirstUseOffset || !var.getSymbol().getAddress().equals(this.variableAddress)) continue;
            return var;
        }
        return null;
    }

    private Address getVariableAddress(Variable var) {
        Symbol sym = var.getSymbol();
        if (sym == null) {
            return Address.NO_ADDRESS;
        }
        if (sym.getProgram() != this.program) {
            Symbol otherSym = SimpleDiffUtility.getVariableSymbol(sym, this.program);
            if (otherSym != null) {
                return otherSym.getAddress();
            }
            return Address.NO_ADDRESS;
        }
        return sym.getAddress();
    }

    public boolean isLocationFor(Variable var) {
        if (!this.functionAddr.equals(var.getFunction().getEntryPoint())) {
            return false;
        }
        if (var instanceof Parameter) {
            return this.isParameter && this.ordinalOrfirstUseOffset == ((Parameter)var).getOrdinal();
        }
        return this.ordinalOrfirstUseOffset == var.getFirstUseOffset() && this.variableAddress.equals(this.getVariableAddress(var));
    }

    public boolean isParameter() {
        return this.isParameter && this.ordinalOrfirstUseOffset != -1;
    }

    public boolean isReturn() {
        return this.isParameter && this.ordinalOrfirstUseOffset == -1;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            VariableLocation loc = (VariableLocation)object;
            if (this.isParameter != loc.isParameter || this.ordinalOrfirstUseOffset != loc.ordinalOrfirstUseOffset) {
                return false;
            }
            return this.isParameter || this.variableAddress.equals(loc.variableAddress);
        }
        return false;
    }

    @Override
    public int compareTo(ProgramLocation pl) {
        if (pl instanceof VariableLocation && pl.getClass() == this.getClass() && pl.getAddress().equals(this.getAddress())) {
            VariableLocation otherLoc = (VariableLocation)pl;
            if (this.isParameter) {
                if (!otherLoc.isParameter) {
                    return -1;
                }
                int retVal = this.ordinalOrfirstUseOffset - otherLoc.ordinalOrfirstUseOffset;
                if (retVal != 0) {
                    return retVal;
                }
            } else {
                if (otherLoc.isParameter) {
                    return 1;
                }
                Variable var = this.getVariable();
                Variable otherVar = otherLoc.getVariable();
                if (var == null) {
                    if (otherVar != null) {
                        return 1;
                    }
                } else {
                    if (otherVar == null) {
                        return -1;
                    }
                    return var.compareTo(otherVar);
                }
            }
        }
        return super.compareTo(pl);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        long offset;
        super.restoreState(p, obj);
        this.isParameter = obj.getBoolean("_IS_PARAMETER", false);
        this.ordinalOrfirstUseOffset = obj.getInt("_ORDINAL_FIRST_USE_OFFSET", 0);
        this.variableAddress = Address.NO_ADDRESS;
        if (obj.hasValue("_VARIABLE_OFFSET") && (offset = obj.getLong("_VARIABLE_OFFSET", -1L)) != -1L) {
            this.variableAddress = AddressSpace.VARIABLE_SPACE.getAddress(offset);
        }
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putBoolean("_IS_PARAMETER", this.isParameter);
        obj.putInt("_ORDINAL_FIRST_USE_OFFSET", this.ordinalOrfirstUseOffset);
        if (this.variableAddress.isVariableAddress()) {
            obj.putLong("_VARIABLE_OFFSET", this.variableAddress.getOffset());
        }
    }

    @Override
    public boolean isValid(Program p) {
        if (!super.isValid(p)) {
            return false;
        }
        return this.getVariable() != null;
    }
}

