/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.SystemUtilities;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ParamEntry {
    private static final int FORCE_LEFT_JUSTIFY = 1;
    private static final int REVERSE_STACK = 2;
    private static final int SMALLSIZE_ZEXT = 4;
    private static final int SMALLSIZE_SEXT = 8;
    private static final int IS_BIG_ENDIAN = 16;
    private static final int SMALLSIZE_INTTYPE = 32;
    private static final int SMALLSIZE_FLOAT = 64;
    private static final int IS_GROUPED = 512;
    private static final int OVERLAPPING = 256;
    private int flags;
    private StorageClass type;
    private int[] groupSet = new int[1];
    private AddressSpace spaceid;
    private long addressbase;
    private int size;
    private int minsize;
    private int alignment;
    private int numslots;
    private Varnode[] joinrec;

    public ParamEntry(int grp) {
        this.groupSet[0] = grp;
    }

    public int getGroup() {
        return this.groupSet[0];
    }

    public int[] getAllGroups() {
        return this.groupSet;
    }

    public int getSize() {
        return this.size;
    }

    public int getMinSize() {
        return this.minsize;
    }

    public int getAlign() {
        return this.alignment;
    }

    public long getAddressBase() {
        return this.addressbase;
    }

    public StorageClass getType() {
        return this.type;
    }

    public boolean isExclusion() {
        return this.alignment == 0;
    }

    public boolean isReverseStack() {
        return (this.flags & 2) != 0;
    }

    public boolean isGrouped() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isOverlap() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isBigEndian() {
        return (this.flags & 0x10) != 0;
    }

    private boolean isLeftJustified() {
        return (this.flags & 0x10) == 0 || (this.flags & 1) != 0;
    }

    public AddressSpace getSpace() {
        return this.spaceid;
    }

    private Varnode[] getJoinPieces(int sz) {
        int first;
        int num = 0;
        Varnode vn = null;
        if (this.isBigEndian()) {
            first = 0;
            while (sz > 0) {
                if (num >= this.joinrec.length) {
                    return null;
                }
                vn = this.joinrec[num];
                if (vn.getSize() > sz) {
                    ++num;
                    break;
                }
                sz -= vn.getSize();
                ++num;
            }
            replace = num - 1;
        } else {
            while (sz > 0) {
                if (num >= this.joinrec.length) {
                    return null;
                }
                vn = this.joinrec[this.joinrec.length - 1 - num];
                if (vn.getSize() > sz) {
                    ++num;
                    break;
                }
                sz -= vn.getSize();
                ++num;
            }
            replace = first = this.joinrec.length - num;
        }
        if (sz == 0 && num == this.joinrec.length) {
            return this.joinrec;
        }
        Varnode[] res = new Varnode[num];
        for (int i = 0; i < num; ++i) {
            res[i] = this.joinrec[first + i];
        }
        if (sz > 0) {
            res[replace] = new Varnode(vn.getAddress(), sz);
        }
        return res;
    }

    public boolean containedBy(Address addr, int sz) {
        if (this.spaceid != addr.getAddressSpace()) {
            return false;
        }
        if (Long.compareUnsigned(this.addressbase, addr.getOffset()) < 0) {
            return false;
        }
        long thisEnd = this.addressbase + (long)this.size - 1L;
        long rangeEnd = addr.getOffset() + (long)sz - 1L;
        return Long.compareUnsigned(thisEnd, rangeEnd) <= 0;
    }

    public boolean intersects(Address addr, int sz) {
        long rangeend;
        if (this.joinrec != null) {
            rangeend = addr.getOffset() + (long)sz - 1L;
            for (Varnode vn : this.joinrec) {
                if (addr.getAddressSpace().getSpaceID() != vn.getSpace()) continue;
                long vnend = vn.getOffset() + (long)vn.getSize() - 1L;
                if (Long.compareUnsigned(addr.getOffset(), vn.getOffset()) < 0 && Long.compareUnsigned(rangeend, vnend) < 0 || Long.compareUnsigned(addr.getOffset(), vn.getOffset()) > 0 && Long.compareUnsigned(rangeend, vnend) > 0) continue;
                return true;
            }
        }
        if (this.spaceid.getSpaceID() != addr.getAddressSpace().getSpaceID()) {
            return false;
        }
        rangeend = addr.getOffset() + (long)sz - 1L;
        long thisend = this.addressbase + (long)this.size - 1L;
        if (Long.compareUnsigned(addr.getOffset(), this.addressbase) < 0 && Long.compareUnsigned(rangeend, thisend) < 0) {
            return false;
        }
        return Long.compareUnsigned(addr.getOffset(), this.addressbase) <= 0 || Long.compareUnsigned(rangeend, thisend) <= 0;
    }

    public int justifiedContain(Address addr, int sz) {
        if (this.joinrec != null) {
            int res = 0;
            for (int i = this.joinrec.length - 1; i >= 0; --i) {
                Varnode vdata = this.joinrec[i];
                int cur = ParamEntry.justifiedContainAddress(vdata.getAddress().getAddressSpace(), vdata.getOffset(), vdata.getSize(), addr.getAddressSpace(), addr.getOffset(), sz, false, (this.flags & 0x10) != 0);
                if (cur < 0) {
                    res += vdata.getSize();
                    continue;
                }
                return res + cur;
            }
            return -1;
        }
        if (this.alignment == 0) {
            return ParamEntry.justifiedContainAddress(this.spaceid, this.addressbase, this.size, addr.getAddressSpace(), addr.getOffset(), sz, (this.flags & 1) != 0, (this.flags & 0x10) != 0);
        }
        if (this.spaceid != addr.getAddressSpace()) {
            return -1;
        }
        long startaddr = addr.getOffset();
        if (Long.compareUnsigned(startaddr, this.addressbase) < 0) {
            return -1;
        }
        long endaddr = startaddr + (long)sz - 1L;
        if (Long.compareUnsigned(endaddr, startaddr) < 0) {
            return -1;
        }
        if (Long.compareUnsigned(this.addressbase + (long)this.size - 1L, endaddr) < 0) {
            return -1;
        }
        startaddr -= this.addressbase;
        endaddr -= this.addressbase;
        if (!this.isLeftJustified()) {
            int res = (int)((endaddr + 1L) % (long)this.alignment);
            if (res == 0) {
                return 0;
            }
            return this.alignment - res;
        }
        return (int)(startaddr % (long)this.alignment);
    }

    public boolean contains(ParamEntry otherEntry) {
        if (otherEntry.joinrec != null) {
            return false;
        }
        if (this.joinrec == null) {
            Address addr = this.spaceid.getAddress(this.addressbase);
            return otherEntry.containedBy(addr, this.size);
        }
        for (Varnode vn : this.joinrec) {
            if (!otherEntry.containedBy(vn.getAddress(), vn.getSize())) continue;
            return true;
        }
        return false;
    }

    public int getSlot(Address addr, int skip) {
        int res = this.groupSet[0];
        if (this.alignment != 0) {
            long diff = addr.getOffset() + (long)skip - this.addressbase;
            int baseslot = (int)diff / this.alignment;
            res = this.isReverseStack() ? (res += this.numslots - 1 - baseslot) : (res += baseslot);
        } else if (skip != 0) {
            res = this.groupSet[this.groupSet.length - 1];
        }
        return res;
    }

    public int getAddrBySlot(int slotnum, int sz, int typeAlign, ParameterPieces res) {
        return this.getAddrBySlot(slotnum, sz, typeAlign, res, !this.isLeftJustified());
    }

    public int getAddrBySlot(int slotnum, int sz, int typeAlign, ParameterPieces res, boolean justifyRight) {
        int spaceused;
        long offset;
        res.address = null;
        if (sz < this.minsize) {
            return slotnum;
        }
        if (this.alignment == 0) {
            if (slotnum != 0) {
                return slotnum;
            }
            if (sz > this.size) {
                return slotnum;
            }
            offset = this.addressbase;
            spaceused = this.size;
            if ((this.flags & 0x40) != 0 && sz != this.size) {
                res.address = this.spaceid.getAddress(offset);
                res.joinPieces = new Varnode[1];
                res.joinPieces[0] = new Varnode(res.address, this.size);
                return slotnum;
            }
        } else {
            int index;
            int tmp;
            if (typeAlign > this.alignment && (tmp = slotnum * this.alignment % typeAlign) != 0) {
                slotnum += (typeAlign - tmp) / this.alignment;
            }
            int slotsused = sz / this.alignment;
            if (sz % this.alignment != 0) {
                ++slotsused;
            }
            if (slotnum + slotsused > this.numslots) {
                return slotnum;
            }
            spaceused = slotsused * this.alignment;
            if (this.isReverseStack()) {
                index = this.numslots;
                index -= slotnum;
                index -= slotsused;
            } else {
                index = slotnum;
            }
            offset = this.addressbase + (long)(index * this.alignment);
            slotnum += slotsused;
        }
        if (justifyRight) {
            offset += (long)(spaceused - sz);
        }
        res.address = this.spaceid.getAddress(offset);
        if (res.address.getAddressSpace().getType() == 6) {
            res.joinPieces = this.getJoinPieces(sz);
        }
        return slotnum;
    }

    private static ParamEntry findEntryByStorage(List<ParamEntry> curList, Varnode varnode) {
        ListIterator<ParamEntry> iter = curList.listIterator(curList.size());
        while (iter.hasPrevious()) {
            ParamEntry entry = iter.previous();
            if (entry.spaceid.getSpaceID() != varnode.getSpace() || entry.addressbase != varnode.getOffset() || entry.size != varnode.getSize()) continue;
            return entry;
        }
        return null;
    }

    private void resolveJoin(List<ParamEntry> curList) throws XmlParseException {
        if (this.joinrec == null) {
            return;
        }
        ArrayList<Integer> newGroupSet = new ArrayList<Integer>();
        for (Varnode piece : this.joinrec) {
            ParamEntry entry = ParamEntry.findEntryByStorage(curList, piece);
            if (entry == null) continue;
            for (int group : entry.groupSet) {
                newGroupSet.add(group);
            }
        }
        if (newGroupSet.isEmpty()) {
            throw new XmlParseException("<pentry> join must overlap at least one previous entry");
        }
        newGroupSet.sort(null);
        this.groupSet = new int[newGroupSet.size()];
        for (int i = 0; i < this.groupSet.length; ++i) {
            this.groupSet[i] = (Integer)newGroupSet.get(i);
        }
        this.flags |= 0x100;
    }

    private void resolveOverlap(List<ParamEntry> curList) throws XmlParseException {
        if (this.joinrec != null) {
            return;
        }
        ArrayList<Integer> newGroupSet = new ArrayList<Integer>();
        Address addr = this.spaceid.getAddress(this.addressbase);
        for (ParamEntry entry : curList) {
            if (entry == this || !entry.intersects(addr, this.size)) continue;
            if (this.contains(entry)) {
                if (entry.isOverlap()) continue;
                for (int group : entry.groupSet) {
                    newGroupSet.add(group);
                }
                continue;
            }
            throw new XmlParseException("Illegal overlap of <pentry> in compiler spec");
        }
        if (newGroupSet.isEmpty()) {
            return;
        }
        newGroupSet.sort(null);
        this.groupSet = new int[newGroupSet.size()];
        for (int i = 0; i < this.groupSet.length; ++i) {
            this.groupSet[i] = (Integer)newGroupSet.get(i);
        }
        this.flags |= 0x100;
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_PENTRY);
        encoder.writeSignedInteger(AttributeId.ATTRIB_MINSIZE, this.minsize);
        encoder.writeSignedInteger(AttributeId.ATTRIB_MAXSIZE, this.size);
        if (this.alignment != 0) {
            encoder.writeSignedInteger(AttributeId.ATTRIB_ALIGN, this.alignment);
        }
        if (this.type != StorageClass.GENERAL) {
            encoder.writeString(AttributeId.ATTRIB_STORAGE, this.type.toString());
        }
        String extString = null;
        if ((this.flags & 8) != 0) {
            extString = "sign";
        } else if ((this.flags & 4) != 0) {
            extString = "zero";
        } else if ((this.flags & 0x20) != 0) {
            extString = "inttype";
        } else if ((this.flags & 0x40) != 0) {
            extString = "float";
        }
        if (extString != null) {
            encoder.writeString(AttributeId.ATTRIB_EXTENSION, extString);
        }
        AddressXML addressSize = this.joinrec == null ? new AddressXML(this.spaceid, this.addressbase, 0) : new AddressXML(this.spaceid, this.addressbase, this.size, this.joinrec);
        addressSize.encode(encoder);
        encoder.closeElement(ElementId.ELEM_PENTRY);
    }

    public void restoreXml(XmlPullParser parser, CompilerSpec cspec, List<ParamEntry> curList, boolean grouped) throws XmlParseException {
        this.flags = 0;
        this.type = StorageClass.GENERAL;
        this.minsize = -1;
        this.size = -1;
        this.alignment = 0;
        this.numslots = 1;
        XmlElement el = parser.start(new String[]{ElementId.ELEM_PENTRY.name()});
        for (Map.Entry entry : el.getAttributes().entrySet()) {
            String name = (String)entry.getKey();
            if (name.equals(AttributeId.ATTRIB_MINSIZE.name())) {
                this.minsize = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_SIZE.name())) {
                this.alignment = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_ALIGN.name())) {
                this.alignment = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_MAXSIZE.name())) {
                this.size = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_STORAGE.name()) || name.equals(AttributeId.ATTRIB_METATYPE.name())) {
                this.type = StorageClass.getClass((String)entry.getValue());
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_EXTENSION.name())) {
                this.flags &= 0xFFFFFF93;
                String value = (String)entry.getValue();
                if (value.equals("sign")) {
                    this.flags |= 8;
                    continue;
                }
                if (value.equals("zero")) {
                    this.flags |= 4;
                    continue;
                }
                if (value.equals("inttype")) {
                    this.flags |= 0x20;
                    continue;
                }
                if (value.equals("float")) {
                    this.flags |= 0x40;
                    continue;
                }
                if (value.equals("none")) continue;
                throw new XmlParseException("Bad extension attribute: " + value);
            }
            throw new XmlParseException("Unknown paramentry attribute: " + name);
        }
        if (this.minsize < 1 || this.size < this.minsize) {
            throw new XmlParseException("paramentry size not specified properly: minsize=" + this.minsize + " maxsize=" + this.size);
        }
        if (this.alignment == this.size) {
            this.alignment = 0;
        }
        XmlElement subel = parser.start(new String[0]);
        AddressXML addressSized = AddressXML.restoreXml(subel, cspec);
        parser.end(subel);
        if (addressSized.getSize() != 0L && (long)this.size > addressSized.getSize()) {
            throw new XmlParseException("<pentry> maxsize is bigger than memory range");
        }
        addressSized.getFirstAddress();
        this.spaceid = addressSized.getAddressSpace();
        this.addressbase = addressSized.getOffset();
        this.joinrec = addressSized.getJoinRecord();
        boolean isbigendian = cspec.getLanguage().isBigEndian();
        if (isbigendian) {
            this.flags |= 0x10;
        }
        if (this.alignment != 0) {
            this.numslots = this.size / this.alignment;
        }
        if (this.spaceid.isStackSpace() && !cspec.isStackRightJustified() && isbigendian) {
            this.flags |= 1;
        }
        if (!cspec.stackGrowsNegative()) {
            this.flags |= 2;
            if (this.alignment != 0 && this.size % this.alignment != 0) {
                throw new XmlParseException("For positive stack growth, <pentry> size must match alignment");
            }
        }
        if (grouped) {
            this.flags |= 0x200;
        }
        this.resolveJoin(curList);
        this.resolveOverlap(curList);
        parser.end(el);
    }

    public boolean isEquivalent(ParamEntry obj) {
        if (!this.spaceid.equals(obj.spaceid) || this.addressbase != obj.addressbase) {
            return false;
        }
        if (this.size != obj.size || this.minsize != obj.minsize || this.alignment != obj.alignment) {
            return false;
        }
        if (this.type != obj.type || this.flags != obj.flags) {
            return false;
        }
        if (this.numslots != obj.numslots) {
            return false;
        }
        if (this.groupSet.length != obj.groupSet.length) {
            return false;
        }
        for (int i = 0; i < this.groupSet.length; ++i) {
            if (this.groupSet[i] == obj.groupSet[i]) continue;
            return false;
        }
        return SystemUtilities.isArrayEqual((Object[])this.joinrec, (Object[])obj.joinrec);
    }

    public static int justifiedContainAddress(AddressSpace spc1, long offset1, int sz1, AddressSpace spc2, long offset2, int sz2, boolean forceleft, boolean isBigEndian) {
        if (spc1 != spc2) {
            return -1;
        }
        if (Long.compareUnsigned(offset2, offset1) < 0) {
            return -1;
        }
        long off1 = offset1 + (long)(sz1 - 1);
        long off2 = offset2 + (long)(sz2 - 1);
        if (Long.compareUnsigned(off1, off2) < 0) {
            return -1;
        }
        if (isBigEndian && !forceleft) {
            return (int)(off1 - off2);
        }
        return (int)(offset2 - offset1);
    }

    public static StorageClass getBasicTypeClass(DataType tp) {
        if (tp instanceof TypeDef) {
            tp = ((TypeDef)tp).getBaseDataType();
        }
        if (tp instanceof AbstractFloatDataType) {
            return StorageClass.FLOAT;
        }
        if (tp instanceof Pointer) {
            return StorageClass.PTR;
        }
        return StorageClass.GENERAL;
    }

    public static void orderWithinGroup(ParamEntry entry1, ParamEntry entry2) throws XmlParseException {
        if (entry2.minsize > entry1.size || entry1.minsize > entry2.size) {
            return;
        }
        if (entry1.type != entry2.type) {
            if (entry1.type == StorageClass.GENERAL) {
                throw new XmlParseException("<pentry> tags with a specific type must come before the general type");
            }
            return;
        }
        throw new XmlParseException("<pentry> tags within a group must be distinguished by size or type");
    }
}

