/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.util.StringUtilities;

public interface InternalDataTypeComponent
extends DataTypeComponent {
    public void setDataType(DataType var1);

    public void update(int var1, int var2, int var3);

    public static String toString(DataTypeComponent c) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  " + c.getOrdinal());
        buffer.append("  " + c.getOffset());
        buffer.append("  " + c.getDataType().getName());
        if (c.isBitFieldComponent()) {
            buffer.append("(" + ((BitFieldDataType)c.getDataType()).getBitOffset() + ")");
        }
        buffer.append("  " + c.getLength());
        String name = c.getFieldName();
        if (name == null) {
            name = "";
        }
        buffer.append("  " + name);
        String cmt = c.getComment();
        buffer.append("  " + (String)(cmt != null ? "\"" + cmt + "\"" : ""));
        return buffer.toString();
    }

    public static String cleanupFieldName(String name) {
        String fieldName = name;
        if (name != null) {
            fieldName = name.trim();
            fieldName = fieldName.length() == 0 ? null : StringUtilities.whitespaceToUnderscores((String)fieldName);
        }
        return fieldName;
    }
}

