/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.map;

import db.DBRecord;
import db.Field;
import db.Table;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.util.RecordFilter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.KeyRange;
import java.io.IOException;
import java.util.List;

public class AddressRecordDeleter {
    private AddressRecordDeleter() {
    }

    public static boolean deleteRecords(Table table, AddressMap addrMap, Address start, Address end) throws IOException {
        List<KeyRange> keyRangeList = addrMap.getKeyRanges(start, end, false);
        boolean success = false;
        for (KeyRange kr : keyRangeList) {
            success |= table.deleteRecords(kr.minKey, kr.maxKey);
        }
        return success;
    }

    public static boolean deleteRecords(Table table, int colIx, AddressMap addrMap, Address start, Address end, RecordFilter filter) throws IOException {
        boolean success = false;
        AddressIndexPrimaryKeyIterator iter = new AddressIndexPrimaryKeyIterator(table, colIx, addrMap, start, end, true);
        while (iter.hasNext()) {
            DBRecord record;
            Field next = iter.next();
            if (filter != null && !filter.matches(record = table.getRecord(next))) continue;
            success |= iter.delete();
        }
        return success;
    }
}

