/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import java.util.Map;
import java.util.Objects;

public class DefaultAssemblyResolvedBackfill
extends AbstractAssemblyResolution
implements AssemblyResolvedBackfill {
    protected final PatternExpression exp;
    protected final MaskedLong goal;
    protected final int inslen;
    protected final int offset;

    protected DefaultAssemblyResolvedBackfill(AbstractAssemblyResolutionFactory<?, ?> factory, String description, PatternExpression exp, MaskedLong goal, int inslen, int offset) {
        super(factory, description, null, null);
        this.exp = Objects.requireNonNull(exp);
        this.goal = Objects.requireNonNull(goal);
        this.inslen = inslen;
        this.offset = offset;
    }

    @Override
    protected int computeHash() {
        int result = 0;
        result += this.exp.hashCode();
        result *= 31;
        result += this.goal.hashCode();
        result *= 31;
        result += this.inslen;
        result *= 31;
        return result += this.offset;
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedBackfillBuilder<?> copyBuilder() {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedBackfillBuilder builder = this.factory.newBackfillBuilder();
        builder.description = this.description;
        builder.exp = this.exp;
        builder.goal = this.goal;
        builder.inslen = this.inslen;
        builder.offset = this.offset;
        return builder;
    }

    protected AssemblyResolvedBackfill copy() {
        return (AssemblyResolvedBackfill)this.copyBuilder().build();
    }

    @Override
    public AssemblyResolvedBackfill withRight(AssemblyResolution right) {
        throw new AssertionError();
    }

    @Override
    public int getInstructionLength() {
        return this.offset + this.inslen;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isBackfill() {
        return true;
    }

    @Override
    public String lineToString() {
        return "Backfill (len:" + this.inslen + ",off:" + this.offset + ") " + String.valueOf(this.goal) + " := " + String.valueOf(this.exp) + " (" + this.description + ")";
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedBackfillBuilder<?> shiftBuilder(int amt) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedBackfillBuilder builder = this.factory.newBackfillBuilder();
        builder.description = this.description;
        builder.exp = this.exp;
        builder.goal = this.goal;
        builder.inslen = this.inslen;
        builder.offset = this.offset + amt;
        return builder;
    }

    @Override
    public AssemblyResolvedBackfill shift(int amt) {
        return (AssemblyResolvedBackfill)this.shiftBuilder(amt).build();
    }

    @Override
    public AssemblyResolution parent(String description, int opCount) {
        throw new AssertionError();
    }

    @Override
    public AssemblyResolution solve(RecursiveDescentSolver solver, Map<String, Long> vals, AssemblyResolvedPatterns cur) {
        try {
            AssemblyResolution ar = solver.solve(this.factory, this.exp, this.goal, vals, cur.truncate(this.offset), this.description);
            if (ar.isError()) {
                return ar;
            }
            AssemblyResolvedPatterns rc = (AssemblyResolvedPatterns)ar;
            return rc.shift(this.offset);
        }
        catch (NeedsBackfillException e) {
            return ((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)this.factory.newErrorBuilder().error("Solution still requires backfill").description(this.description)).build();
        }
        catch (UnsupportedOperationException e) {
            return ((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)this.factory.newErrorBuilder().error("Unsupported: " + e.getMessage()).description(this.description)).build();
        }
    }
}

