/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class GFileSystemIterator
implements Iterator<GFile> {
    private Deque<GFile> fileDeque = new ArrayDeque<GFile>();
    private Deque<GFile> dirDeque = new ArrayDeque<GFile>();
    private Predicate<GFile> filter;

    public GFileSystemIterator(GFileSystem fs) {
        this(fs.getRootDir());
    }

    public GFileSystemIterator(GFile dir) throws UncheckedIOException {
        this(dir, file -> true);
    }

    public GFileSystemIterator(GFile dir, Predicate<GFile> fileFilter) throws UncheckedIOException {
        if (!dir.isDirectory()) {
            throw new UncheckedIOException(new IOException("Invalid starting directory!"));
        }
        this.dirDeque.push(dir);
        this.filter = fileFilter;
    }

    @Override
    public boolean hasNext() {
        this.queueNextFiles();
        return !this.fileDeque.isEmpty();
    }

    @Override
    public GFile next() {
        this.queueNextFiles();
        return this.fileDeque.pop();
    }

    private void queueNextFiles() throws UncheckedIOException {
        while (this.fileDeque.isEmpty() && !this.dirDeque.isEmpty()) {
            try {
                List<GFile> listing = this.dirDeque.pop().getListing();
                listing.stream().filter(GFile::isDirectory).sorted(Comparator.comparing(GFile::getName).reversed()).forEach(this.dirDeque::push);
                listing.stream().filter(Predicate.not(GFile::isDirectory)).filter(this.filter).sorted(Comparator.comparing(GFile::getName).reversed()).forEach(this.fileDeque::push);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

