/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomModuleEntry
implements StructConverter {
    public static final int SIZE = 20;
    private int drelocs;
    private int imports;
    private int importCount;
    private int flags;
    private int reserved1;
    private int moduleDependencies;
    private int reserved2;

    public SomModuleEntry(BinaryReader reader) throws IOException {
        this.drelocs = reader.readNextInt();
        this.imports = reader.readNextInt();
        this.importCount = reader.readNextInt();
        this.flags = reader.readNextUnsignedByte();
        this.reserved1 = reader.readNextUnsignedByte();
        this.moduleDependencies = reader.readNextUnsignedShort();
        this.reserved2 = reader.readNextInt();
    }

    public int getDrelocs() {
        return this.drelocs;
    }

    public int getImports() {
        return this.imports;
    }

    public int getImportCount() {
        return this.importCount;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public int getModuleDependencies() {
        return this.moduleDependencies;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("module_entry", 20);
        struct.setPackingEnabled(true);
        struct.add(DWORD, "drelocs", "text offset into module dynamic relocation array");
        struct.add(DWORD, "imports", "text offset into module import array");
        struct.add(DWORD, "imports_count", "number of entries into module import array");
        struct.add(BYTE, "flags", "currently flags defined: ELAB_REF");
        struct.add(BYTE, "reserved1", null);
        struct.add(WORD, "module_dependencies", null);
        struct.add(DWORD, "reserved2", null);
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

