/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EntryPointCommand
extends LoadCommand {
    private long entryOffset;
    private long stackSize;

    EntryPointCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.entryOffset = reader.readNextLong();
        this.stackSize = reader.readNextLong();
    }

    public long getEntryOffset() {
        return this.entryOffset;
    }

    public long getStackSize() {
        return this.stackSize;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(QWORD, "entryoff", null);
        struct.add(QWORD, "stacksize", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "entry_point_command";
    }
}

