/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.elf.info.GnuDebugLink;
import ghidra.app.util.bin.format.elf.info.NoteGnuBuildId;
import ghidra.program.model.listing.Program;
import ghidra.util.NumericUtilities;

public class ExternalDebugInfo {
    private String filename;
    private int crc;
    private byte[] hash;

    public static ExternalDebugInfo fromProgram(Program program) {
        GnuDebugLink debugLink = GnuDebugLink.fromProgram(program);
        NoteGnuBuildId buildId = NoteGnuBuildId.fromProgram(program);
        if (debugLink == null && buildId == null) {
            return null;
        }
        String filename = debugLink != null ? debugLink.getFilename() : null;
        int crc = debugLink != null ? debugLink.getCrc() : 0;
        byte[] hash = buildId != null ? buildId.getDescription() : null;
        return new ExternalDebugInfo(filename, crc, hash);
    }

    public ExternalDebugInfo(String filename, int crc, byte[] hash) {
        this.filename = filename;
        this.crc = crc;
        this.hash = hash;
    }

    public boolean hasFilename() {
        return this.filename != null && !this.filename.isBlank();
    }

    public String getFilename() {
        return this.filename;
    }

    public int getCrc() {
        return this.crc;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String toString() {
        return String.format("ExternalDebugInfo [filename=%s, crc=%s, hash=%s]", this.filename, Integer.toHexString(this.crc), NumericUtilities.convertBytesToString((byte[])this.hash));
    }
}

