/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.bin.format.dwarf.DIEAggregate;
import ghidra.app.util.bin.format.dwarf.DWARFDataTypeManager;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFLocation;
import ghidra.app.util.bin.format.dwarf.DWARFLocationList;
import ghidra.app.util.bin.format.dwarf.DWARFName;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFRange;
import ghidra.app.util.bin.format.dwarf.DWARFRangeList;
import ghidra.app.util.bin.format.dwarf.DWARFSourceInfo;
import ghidra.app.util.bin.format.dwarf.DWARFTag;
import ghidra.app.util.bin.format.dwarf.DWARFVariable;
import ghidra.app.util.bin.format.dwarf.NameDeduper;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionEvaluator;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf.funcfixup.DWARFFunctionFixup;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariable;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DWARFFunction {
    public DIEAggregate diea;
    public DWARFName name;
    public Namespace namespace;
    private DWARFRangeList dwarfBody;
    public Address address;
    public Function function;
    public DWARFLocation funcEntryFrameBaseLoc;
    public String callingConventionName;
    public DWARFVariable retval;
    public List<DWARFVariable> params = new ArrayList<DWARFVariable>();
    public boolean varArg;
    public List<DWARFVariable> localVars = new ArrayList<DWARFVariable>();
    public boolean localVarErrors;
    public CommitMode signatureCommitMode = CommitMode.STORAGE;
    public boolean noReturn;
    public DWARFSourceInfo sourceInfo;
    public boolean isExternal;

    public static DWARFFunction read(DIEAggregate diea) throws IOException {
        DWARFLocation frameLoc;
        if (diea.isDanglingDeclaration()) {
            return null;
        }
        DWARFRangeList bodyRanges = DWARFFunction.getFuncBodyRanges(diea);
        if (bodyRanges.isEmpty()) {
            return null;
        }
        DWARFProgram prog = diea.getProgram();
        DWARFDataTypeManager dwarfDTM = prog.getDwarfDTM();
        DWARFFunction dfunc = new DWARFFunction(diea, prog.getName(diea), bodyRanges);
        dfunc.namespace = dfunc.name.getParentNamespace(prog.getGhidraProgram());
        dfunc.sourceInfo = DWARFSourceInfo.create(diea);
        dfunc.isExternal = diea.getBool(DWARFAttribute.DW_AT_external, false);
        dfunc.noReturn = diea.getBool(DWARFAttribute.DW_AT_noreturn, false);
        DWARFLocationList frameBaseLocs = diea.getLocationList(DWARFAttribute.DW_AT_frame_base);
        if (!frameBaseLocs.isEmpty() && (frameLoc = frameBaseLocs.getLocationContaining(dfunc.getEntryPc())) != null) {
            try {
                DWARFExpressionEvaluator evaluator = new DWARFExpressionEvaluator(diea.getCompilationUnit());
                if (prog.getImportOptions().isUseStaticStackFrameRegisterValue()) {
                    evaluator.setValReader(evaluator.withStaticStackRegisterValues(null, prog.getRegisterMappings().getStackFrameRegisterOffset()));
                }
                evaluator.evaluate(frameLoc.getExpr());
                frameLoc.setResolvedValue(evaluator.popVarnode());
                dfunc.funcEntryFrameBaseLoc = frameLoc;
            }
            catch (DWARFExpressionException e) {
                prog.getImportSummary().addProblematicDWARFExpression(e.getExpression());
            }
        }
        dfunc.retval = DWARFVariable.fromDataType(dfunc, dwarfDTM.getDataTypeForVariable(diea.getTypeRef()));
        int paramOrdinal = 0;
        for (DIEAggregate paramDIEA : diea.getFunctionParamList()) {
            DWARFVariable param = DWARFVariable.readParameter(paramDIEA, dfunc, paramOrdinal++);
            dfunc.params.add(param);
        }
        dfunc.varArg = !diea.getChildren(DWARFTag.DW_TAG_unspecified_parameters).isEmpty();
        return dfunc;
    }

    private DWARFFunction(DIEAggregate diea, DWARFName dni, DWARFRangeList dwarfBody) {
        this.diea = diea;
        this.name = dni;
        this.dwarfBody = dwarfBody;
        this.address = diea.getProgram().getCodeAddress(dwarfBody.getFirstAddress());
    }

    public DWARFProgram getProgram() {
        return this.diea.getProgram();
    }

    public String getDescriptiveName() {
        return "%s@%s".formatted(this.name.getName(), this.address);
    }

    public DWARFRangeList getRangeList() {
        return this.dwarfBody;
    }

    public String getCallingConventionName() {
        return this.callingConventionName;
    }

    public AddressSetView getBody() {
        DWARFProgram dprog = this.getProgram();
        AddressSet result = new AddressSet();
        for (DWARFRange drange : this.dwarfBody.ranges()) {
            if (drange.isEmpty()) continue;
            Address start = dprog.getCodeAddress(drange.getFrom());
            Address end = dprog.getCodeAddress(drange.getTo() - 1L);
            result.add((AddressRange)new AddressRangeImpl(start, end));
        }
        return result;
    }

    public long getEntryPc() {
        return this.dwarfBody.getFirstAddress();
    }

    public DWARFVariable getLocalVarByOffset(long offset) {
        for (DWARFVariable localVar : this.localVars) {
            if (!localVar.isStackStorage() || localVar.getStackOffset() != offset) continue;
            return localVar;
        }
        return null;
    }

    public boolean isInLocalVarStorageArea(long offset) {
        boolean paramsHavePositiveOffset = this.diea.getProgram().stackGrowsNegative();
        return paramsHavePositiveOffset && offset < 0L || !paramsHavePositiveOffset && offset >= 0L;
    }

    public boolean hasConflictWithParamStorage(DWARFVariable dvar) throws InvalidInputException {
        if (dvar.lexicalOffset != 0L) {
            return false;
        }
        VariableStorage storage = dvar.getVariableStorage();
        for (DWARFVariable param : this.params) {
            VariableStorage paramStorage = param.getVariableStorage();
            if (!paramStorage.intersects(storage)) continue;
            return true;
        }
        return false;
    }

    public boolean hasConflictWithExistingLocalVariableStorage(DWARFVariable dvar) throws InvalidInputException {
        VariableStorage newVarStorage = dvar.getVariableStorage();
        for (Variable existingVar : this.function.getAllVariables()) {
            if ((long)existingVar.getFirstUseOffset() != dvar.lexicalOffset || !existingVar.getVariableStorage().intersects(newVarStorage) || existingVar instanceof LocalVariable && Undefined.isUndefined((DataType)existingVar.getDataType())) continue;
            return true;
        }
        return false;
    }

    public List<String> getAllParamNames() {
        return this.params.stream().filter(dvar -> !dvar.name.isAnon()).map(dvar -> dvar.name.getName()).collect(Collectors.toList());
    }

    public List<String> getAllLocalVariableNames() {
        return this.localVars.stream().filter(dvar -> !dvar.name.isAnon()).map(dvar -> dvar.name.getName()).collect(Collectors.toList());
    }

    public List<String> getExistingLocalVariableNames() {
        return Arrays.stream(this.function.getLocalVariables()).filter(var -> var.getName() != null && !Undefined.isUndefined((DataType)var.getDataType())).map(var -> var.getName()).collect(Collectors.toList());
    }

    public List<String> getNonParamSymbolNames() {
        SymbolIterator symbols = this.function.getProgram().getSymbolTable().getSymbols((Namespace)this.function);
        return StreamSupport.stream(symbols.spliterator(), false).filter(symbol -> symbol.getSymbolType() != SymbolType.PARAMETER).map(Symbol::getName).collect(Collectors.toList());
    }

    public List<Parameter> getParameters(boolean includeStorageDetail) throws InvalidInputException {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (DWARFVariable dvar : this.params) {
            result.add(dvar.asParameter(includeStorageDetail));
        }
        return result;
    }

    public ParameterDefinition[] getParameterDefinitions() {
        return (ParameterDefinition[])this.params.stream().map(dvar -> new ParameterDefinitionImpl(dvar.name.getName(), dvar.type, null)).toArray(ParameterDefinition[]::new);
    }

    public void commitLocalVariable(DWARFVariable dvar) {
        VariableStorage varStorage = null;
        try {
            varStorage = dvar.getVariableStorage();
            if (this.hasConflictWithParamStorage(dvar)) {
                this.getProgram().logWarningAt(this.function.getEntryPoint(), this.function.getName(), "Local variable %s[%s] conflicts with parameter, skipped.".formatted(dvar.getDeclInfoString(), varStorage));
                return;
            }
            if (this.hasConflictWithExistingLocalVariableStorage(dvar)) {
                this.getProgram().logWarningAt(this.function.getEntryPoint().add(dvar.lexicalOffset), this.function.getName(), "Local omitted variable %s[%s] scope starts here".formatted(dvar.getDeclInfoString(), varStorage));
                return;
            }
            NameDeduper nameDeduper = new NameDeduper();
            nameDeduper.addReservedNames(this.getAllLocalVariableNames());
            nameDeduper.addUsedNames(this.getAllParamNames());
            nameDeduper.addUsedNames(this.getExistingLocalVariableNames());
            Variable var = dvar.asLocalVariable();
            String origName = var.getName();
            String newName = nameDeduper.getUniqueName(origName);
            if (newName != null) {
                try {
                    var.setName(newName, null);
                }
                catch (DuplicateNameException | InvalidInputException throwable) {
                    // empty catch block
                }
                var.setComment("Original name: " + origName);
            }
            VariableUtilities.checkVariableConflict((Function)this.function, (Variable)var, (VariableStorage)varStorage, (boolean)true);
            this.function.addLocalVariable(var, SourceType.IMPORTED);
        }
        catch (DuplicateNameException | InvalidInputException | IllegalArgumentException e) {
            this.getProgram().logWarningAt(this.function.getEntryPoint().add(dvar.lexicalOffset), this.function.getName(), "Local omitted variable %s[%s] scope starts here".formatted(dvar.getDeclInfoString(), varStorage != null ? varStorage.toString() : "UNKNOWN"));
        }
    }

    public static AddressRange getFuncBody(DIEAggregate diea, boolean flattenDisjoint) throws IOException {
        DWARFProgram dprog = diea.getProgram();
        DWARFRangeList bodyRangeList = DWARFFunction.getFuncBodyRanges(diea);
        if (bodyRangeList.isEmpty()) {
            return null;
        }
        DWARFRange bodyRange = flattenDisjoint ? bodyRangeList.getFlattenedRange() : bodyRangeList.getFirst();
        return dprog.getAddressRange(bodyRange, true);
    }

    public static DWARFRangeList getFuncBodyRanges(DIEAggregate diea) throws IOException {
        DWARFRange body = diea.getPCRange();
        if (!body.isEmpty()) {
            return new DWARFRangeList(body);
        }
        if (diea.hasAttribute(DWARFAttribute.DW_AT_ranges)) {
            return diea.getRangeList(DWARFAttribute.DW_AT_ranges);
        }
        return DWARFRangeList.EMTPY;
    }

    public boolean syncWithExistingGhidraFunction(boolean createIfMissing) {
        try {
            Program currentProgram = this.getProgram().getGhidraProgram();
            this.function = currentProgram.getListing().getFunctionAt(this.address);
            if (this.function != null && this.function.hasNoReturn() && !this.noReturn) {
                this.noReturn = true;
            }
            if (!createIfMissing && this.function == null) {
                return false;
            }
            SymbolTable symbolTable = currentProgram.getSymbolTable();
            symbolTable.createLabel(this.address, this.name.getName(), this.namespace, SourceType.IMPORTED);
            SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(this.address, this.name.getName(), this.namespace);
            cmd.applyTo(currentProgram);
            if (this.isExternal) {
                currentProgram.getSymbolTable().addExternalEntryPoint(this.address);
            } else {
                currentProgram.getSymbolTable().removeExternalEntryPoint(this.address);
            }
            this.function = currentProgram.getListing().getFunctionAt(this.address);
            if (this.function == null) {
                if (!currentProgram.getMemory().getLoadedAndInitializedAddressSet().contains(this.address)) {
                    Msg.warn((Object)this, (Object)"DWARF: unable to create function not contained within loaded memory: %s@%s".formatted(this.name, this.address));
                    return false;
                }
                if (currentProgram.getListing().getDefinedDataAt(this.address) != null) {
                    this.getProgram().logWarningAt(this.address, this.name.getName(), "DWARF: unable to create function at location that is marked as data: %s".formatted(this.name.getName()));
                    return false;
                }
                this.function = currentProgram.getFunctionManager().createFunction(null, this.address, (AddressSetView)new AddressSet(this.address), SourceType.IMPORTED);
            }
            return true;
        }
        catch (OverlappingFunctionException e) {
            throw new AssertException((Throwable)e);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Failed to create function " + String.valueOf(this.namespace) + "/" + this.name.getName() + ": " + e.getMessage()));
            return false;
        }
    }

    public void runFixups() {
        for (DWARFFunctionFixup fixup : this.getProgram().getFunctionFixups()) {
            try {
                fixup.fixupDWARFFunction(this);
            }
            catch (DWARFException e) {
                this.signatureCommitMode = CommitMode.SKIP;
            }
            if (this.signatureCommitMode != CommitMode.SKIP) continue;
            break;
        }
    }

    public void updateFunctionSignature() {
        try {
            boolean includeStorageDetail = this.signatureCommitMode == CommitMode.STORAGE;
            Function.FunctionUpdateType functionUpdateType = includeStorageDetail ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS;
            Parameter returnVar = this.retval.asReturnParameter(includeStorageDetail);
            List<Parameter> parameters = this.getParameters(includeStorageDetail);
            if (includeStorageDetail && !this.retval.isZeroByte() && this.retval.isMissingStorage()) {
                this.function.updateFunction(this.callingConventionName, (Variable)returnVar, List.of(), Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.IMPORTED);
                returnVar = null;
            }
            this.function.updateFunction(this.callingConventionName, (Variable)returnVar, parameters, functionUpdateType, true, SourceType.IMPORTED);
            this.function.setVarArgs(this.varArg);
            this.function.setNoReturn(this.noReturn);
        }
        catch (DuplicateNameException | InvalidInputException | IllegalArgumentException e) {
            Msg.error((Object)this, (Object)"Error updating function %s@%s with params: %s".formatted(this.function.getName(), this.function.getEntryPoint().toString(), e.getMessage()));
            Msg.error((Object)this, (Object)("DIE info: " + this.diea.toString()));
        }
    }

    public FunctionDefinition asFunctionDefinition(boolean includeCC) {
        ProgramBasedDataTypeManager dtm = this.getProgram().getGhidraProgram().getDataTypeManager();
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(this.name.getParentCP(), this.name.getName(), (DataTypeManager)dtm);
        funcDef.setReturnType(this.retval.type);
        funcDef.setNoReturn(this.noReturn);
        funcDef.setArguments(this.getParameterDefinitions());
        if (this.varArg) {
            funcDef.setVarArgs(true);
        }
        if (this.getProgram().getImportOptions().isOutputSourceLocationInfo() && this.sourceInfo != null) {
            funcDef.setComment(this.sourceInfo.getDescriptionStr());
        }
        if (includeCC && this.callingConventionName != null) {
            try {
                funcDef.setCallingConvention(this.callingConventionName);
            }
            catch (InvalidInputException e) {
                Msg.warn((Object)this, (Object)"Unable to set calling convention name to %s for function def: %s".formatted(this.callingConventionName, funcDef));
            }
        }
        return funcDef;
    }

    public String toString() {
        return String.format("DWARFFunction [name=%s, address=%s, sourceInfo=%s, retval=%s, params=%s, function=%s, diea=%s, signatureCommitMode=%s]", new Object[]{this.name, this.address, this.sourceInfo, this.retval, this.params, this.function, this.diea, this.signatureCommitMode});
    }

    public static enum CommitMode {
        SKIP,
        FORMAL,
        STORAGE;

    }
}

