/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.scalartable;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableFilter;
import generic.theme.GIcon;
import ghidra.app.plugin.core.scalartable.RangeFilterTextField;
import ghidra.app.plugin.core.scalartable.ScalarRowObject;
import ghidra.app.plugin.core.scalartable.ScalarSearchContext;
import ghidra.app.plugin.core.scalartable.ScalarSearchDialog;
import ghidra.app.plugin.core.scalartable.ScalarSearchModel;
import ghidra.app.plugin.core.scalartable.ScalarSearchPlugin;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.DeleteTableRowAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;

public class ScalarSearchProvider
extends ComponentProviderAdapter {
    public static final Icon ICON = new GIcon("icon.plugin.scalartable.provider");
    private ScalarSearchPlugin plugin;
    private GhidraThreadedTablePanel<ScalarRowObject> threadedTablePanel;
    private GTableFilterPanel<ScalarRowObject> filter;
    private JComponent mainComponent;
    private JPanel mainPanel;
    private GhidraTable scalarTable;
    private ScalarSearchModel scalarModel;
    private ProgramSelection currentSelection;
    private Program program;
    private String primarySubTitle;
    private RangeFilterTextField minField;
    private RangeFilterTextField maxField;

    ScalarSearchProvider(ScalarSearchPlugin plugin, ProgramSelection currentSelection) {
        super(plugin.getTool(), "Scalar Table", plugin.getName());
        this.currentSelection = currentSelection;
        this.program = plugin.getCurrentProgram();
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Scalar_Table"));
        this.mainComponent = this.createWorkPanel();
        this.setIcon(ICON);
        this.setTransient();
        this.setDefaultWindowPosition(WindowPosition.WINDOW);
        this.setWindowGroup("SCALAR_TABLE_SEARCH");
        this.tool.addComponentProvider((ComponentProvider)this, false);
        this.createActions();
    }

    public String getWindowSubMenuName() {
        return "Search";
    }

    void updateSearchRangeValues(ScalarSearchDialog dialog) {
        long minValue = dialog.getMinSearchValue();
        long maxValue = dialog.getMaxSearchValue();
        this.scalarModel.initialize(this.plugin.getCurrentProgram(), minValue, maxValue);
        String minValueText = dialog.getMinSearchValueText();
        String maxValueText = dialog.getMaxSearchValueText();
        this.updateTitle(minValueText, maxValueText);
    }

    private void updateTitle(String minValueText, String maxValueText) {
        StringBuilder buffy = new StringBuilder("Scalar Search");
        if (minValueText.equals(maxValueText)) {
            buffy.append(" [filter: ").append(minValueText).append(']');
        } else if (!this.isDefaultFilterRange(minValueText, maxValueText)) {
            buffy.append(" [filter: ").append(minValueText).append(" - ").append(maxValueText).append(']');
        }
        this.setTitle(buffy.toString());
        buffy = new StringBuilder();
        if (this.currentSelection != null) {
            buffy.append("in Selection: " + this.getSelectionAsString(this.currentSelection));
        }
        buffy.append(" (").append(this.plugin.getCurrentProgram().getName()).append(')');
        this.primarySubTitle = buffy.toString();
        this.setSubTitle(this.primarySubTitle);
    }

    private boolean isDefaultFilterRange(String min, String max) {
        int minValue = this.minField.getLimitValue();
        int maxValue = this.maxField.getLimitValue();
        return min.equals(Integer.toString(minValue)) && max.equals(Integer.toString(maxValue));
    }

    public void componentShown() {
        this.scalarModel.reload();
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ScalarSearchContext(this, this.scalarTable);
    }

    public JComponent getComponent() {
        return this.mainComponent;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.plugin.getName());
    }

    public Program getProgram() {
        return this.program;
    }

    public ScalarSearchModel getScalarModel() {
        return this.scalarModel;
    }

    void programClosed(Program p) {
        if (p == this.program) {
            this.closeComponent();
        }
    }

    void dispose() {
        this.closeComponent();
        this.threadedTablePanel.dispose();
        this.filter.dispose();
    }

    void reload() {
        if (this.isVisible()) {
            this.scalarModel.reload();
        }
    }

    GhidraTable getTable() {
        return this.scalarTable;
    }

    private JComponent createWorkPanel() {
        this.scalarModel = new ScalarSearchModel(this.plugin, this.currentSelection);
        this.threadedTablePanel = new GhidraThreadedTablePanel<ScalarRowObject>(this.scalarModel, 1000);
        this.scalarTable = this.threadedTablePanel.getTable();
        this.filter = new GTableFilterPanel((JTable)((Object)this.scalarTable), (RowObjectTableModel)this.scalarModel);
        this.scalarTable.setName("ScalarTable");
        this.scalarTable.setAutoLookupColumn(1);
        this.scalarTable.setAutoResizeMode(2);
        this.scalarTable.setPreferredScrollableViewportSize(new Dimension(400, 400));
        this.scalarTable.setRowSelectionAllowed(true);
        this.scalarTable.setSelectionMode(2);
        this.scalarTable.getSelectionModel().addListSelectionListener(e -> this.notifyContextChanged());
        this.filter.setSecondaryFilter((TableFilter)new ScalarTableSecondaryFilter());
        this.scalarModel.addTableModelListener(e -> this.setSubTitle(this.primarySubTitle + " " + this.scalarModel.getRowCount() + " items"));
        this.scalarTable.installNavigation((ServiceProvider)this.tool);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)((Object)this.threadedTablePanel), "Center");
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.add((Component)this.filter, "North");
        filterPanel.add((Component)new RangeFilterPanel(), "South");
        this.mainPanel.add((Component)filterPanel, "South");
        return this.mainPanel;
    }

    GTableFilterPanel<ScalarRowObject> getFilterPanel() {
        return this.filter;
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    private String getSelectionAsString(ProgramSelection selection) {
        Address min = selection.getMinAddress();
        Address max = selection.getMaxAddress();
        long n = selection.getNumAddresses();
        return "[" + String.valueOf(min) + ", " + String.valueOf(max) + "; " + n + " addresses]";
    }

    private void createActions() {
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)new MakeProgramSelectionAction(this.plugin, this.scalarTable));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)new SelectionNavigationAction(this.plugin, this.getTable()));
        GhidraTable table = this.threadedTablePanel.getTable();
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)new DeleteTableRowAction(table, this.plugin.getName()));
    }

    private class ScalarTableSecondaryFilter
    implements TableFilter<ScalarRowObject> {
        private ScalarTableSecondaryFilter() {
        }

        public boolean acceptsRow(ScalarRowObject rowObject) {
            Scalar scalar = rowObject.getScalar();
            if (scalar == null) {
                return false;
            }
            long value = scalar.getSignedValue();
            if (value < ScalarSearchProvider.this.minField.getFilterValue()) {
                return false;
            }
            return value <= ScalarSearchProvider.this.maxField.getFilterValue();
        }

        public boolean isSubFilterOf(TableFilter<?> tableFilter) {
            if (!(tableFilter instanceof ScalarTableSecondaryFilter)) {
                return false;
            }
            return false;
        }
    }

    private class RangeFilterPanel
    extends JPanel {
        RangeFilterPanel() {
            Border lowerBorder = BorderFactory.createLoweredBevelBorder();
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(lowerBorder);
            this.add(Box.createHorizontalStrut(4));
            this.add((Component)new GLabel("Min:"));
            this.add(Box.createHorizontalStrut(19));
            ScalarSearchProvider.this.minField = this.createFilterWidget(RangeFilterTextField.FilterType.MIN);
            this.add(ScalarSearchProvider.this.minField.getComponent());
            this.add(Box.createHorizontalStrut(10));
            this.add((Component)new GLabel("Max:"));
            this.add(Box.createHorizontalStrut(5));
            ScalarSearchProvider.this.maxField = this.createFilterWidget(RangeFilterTextField.FilterType.MAX);
            this.add(ScalarSearchProvider.this.maxField.getComponent());
            HelpService help = DockingWindowManager.getHelpService();
            help.registerHelp((Object)this, new HelpLocation(ScalarSearchProvider.this.plugin.getName(), "Filter_Scalars"));
        }

        private RangeFilterTextField createFilterWidget(RangeFilterTextField.FilterType filterType) {
            RangeFilterTextField rangefilter = new RangeFilterTextField(filterType, ScalarSearchProvider.this.program);
            rangefilter.addChangeListener(e -> ScalarSearchProvider.this.scalarModel.reFilter());
            return rangefilter;
        }
    }
}

