/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import ghidra.app.plugin.core.reloc.RelocationFixupHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;

public class Pe32RelocationFixupHandler
extends RelocationFixupHandler {
    @Override
    public boolean processRelocation(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        return this.process32BitRelocation(program, relocation, oldImageBase, newImageBase);
    }

    @Override
    public boolean handlesProgram(Program program) {
        if (!"Portable Executable (PE)".equals(program.getExecutableFormat())) {
            return false;
        }
        Language language = program.getLanguage();
        if (language.getLanguageDescription().getSize() != 32) {
            return false;
        }
        Processor processor = language.getProcessor();
        return processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"x86"));
    }
}

