/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import ghidra.program.model.listing.FunctionTag;
import java.util.Objects;

class InMemoryFunctionTag
implements FunctionTag {
    private final String name;
    private final String comment;

    InMemoryFunctionTag(String name, String comment) {
        this.name = name;
        this.comment = comment == null ? "" : comment;
    }

    public long getId() {
        return -1L;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("immutable tag");
    }

    public void setComment(String comment) {
        throw new UnsupportedOperationException("immutable tag");
    }

    public int compareTo(FunctionTag otherTag) {
        int rc = this.getName().compareToIgnoreCase(otherTag.getName());
        if (rc != 0) {
            return rc;
        }
        return this.getComment().compareToIgnoreCase(otherTag.getComment());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionTag)) {
            return false;
        }
        FunctionTag other = (FunctionTag)obj;
        if (!Objects.equals(this.comment, other.getComment())) {
            return false;
        }
        return Objects.equals(this.name, other.getName());
    }

    public void delete() {
    }

    public String toString() {
        return "In-memory tag: " + this.name;
    }
}

