/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.DialogComponentProvider;
import docking.widgets.button.GButton;
import docking.widgets.checkbox.GCheckBox;
import ghidra.app.plugin.core.datamgr.tree.DtFilterState;
import ghidra.app.plugin.core.datamgr.tree.DtTypeFilter;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DtFilterDialog
extends DialogComponentProvider {
    private TypeComponent arraysComponent = new TypeComponent(this, "Arrays");
    private TypeComponent enumsComponent = new TypeComponent(this, "Enums");
    private TypeComponent functionsComponent = new TypeComponent(this, "Functions");
    private TypeComponent pointersComponent = new TypeComponent(this, "Pointers");
    private TypeComponent structuresComponent = new TypeComponent(this, "Structures");
    private TypeComponent unionsComponent = new TypeComponent(this, "Unions");
    private DtFilterState filterState;
    private boolean isCancelled;

    public DtFilterDialog(DtFilterState filterState) {
        super("Data Types Filter");
        this.filterState = filterState;
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Show Filter"));
        this.initCheckBoxes();
        this.setRememberSize(false);
    }

    protected void cancelCallback() {
        super.cancelCallback();
        this.isCancelled = true;
    }

    protected void okCallback() {
        this.close();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public DtFilterState getFilterState() {
        DtFilterState newState = new DtFilterState();
        newState.setArraysFilter(this.arraysComponent.getFilter());
        newState.setEnumsFilter(this.enumsComponent.getFilter());
        newState.setFunctionsFilter(this.functionsComponent.getFilter());
        newState.setPointersFilter(this.pointersComponent.getFilter());
        newState.setStructuresFilter(this.structuresComponent.getFilter());
        newState.setUnionsFilter(this.unionsComponent.getFilter());
        return newState;
    }

    private JPanel buildWorkPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 2));
        JLabel l1 = new JLabel("<html><b>Show");
        l1.setHorizontalAlignment(2);
        panel.add(l1);
        JLabel l2 = new JLabel("<html><b>Include Typedefs");
        l2.setHorizontalAlignment(0);
        panel.add(l2);
        panel.add(this.arraysComponent.getLeft());
        panel.add(this.arraysComponent.getRight());
        panel.add(this.enumsComponent.getLeft());
        panel.add(this.enumsComponent.getRight());
        panel.add(this.functionsComponent.getLeft());
        panel.add(this.functionsComponent.getRight());
        panel.add(this.pointersComponent.getLeft());
        panel.add(this.pointersComponent.getRight());
        panel.add(this.structuresComponent.getLeft());
        panel.add(this.structuresComponent.getRight());
        panel.add(this.unionsComponent.getLeft());
        panel.add(this.unionsComponent.getRight());
        GButton selectAll = new GButton("Select All");
        GButton deselectAll = new GButton("Deselect All");
        selectAll.addActionListener(e -> this.allButtons().forEach(b -> b.setSelected(true)));
        deselectAll.addActionListener(e -> this.allButtons().forEach(b -> b.setSelected(false)));
        panel.add(Box.createRigidArea(new Dimension(10, 10)));
        panel.add(Box.createRigidArea(new Dimension(10, 10)));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 2));
        p1.add(Box.createHorizontalGlue());
        p1.add((Component)selectAll);
        p1.add(Box.createHorizontalGlue());
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 2));
        p2.add(Box.createHorizontalGlue());
        p2.add((Component)deselectAll);
        p2.add(Box.createHorizontalGlue());
        panel.add(p1);
        panel.add(p2);
        return panel;
    }

    private List<AbstractButton> allButtons() {
        return List.of(this.arraysComponent.typeCb, this.arraysComponent.typeDefCb, this.enumsComponent.typeCb, this.enumsComponent.typeDefCb, this.functionsComponent.typeCb, this.functionsComponent.typeDefCb, this.pointersComponent.typeCb, this.pointersComponent.typeDefCb, this.structuresComponent.typeCb, this.structuresComponent.typeDefCb, this.unionsComponent.typeCb, this.unionsComponent.typeDefCb);
    }

    private void initCheckBoxes() {
        this.arraysComponent.init(this.filterState.getArraysFilter());
        this.enumsComponent.init(this.filterState.getEnumsFilter());
        this.functionsComponent.init(this.filterState.getFunctionsFilter());
        this.pointersComponent.init(this.filterState.getPointersFilter());
        this.structuresComponent.init(this.filterState.getStructuresFilter());
        this.unionsComponent.init(this.filterState.getUnionsFilter());
    }

    private class TypeComponent {
        private String type;
        private GCheckBox typeCb;
        private GCheckBox typeDefCb;

        TypeComponent(DtFilterDialog dtFilterDialog, String type) {
            this.type = type;
            this.typeCb = new GCheckBox(type);
            this.typeDefCb = new GCheckBox();
            this.typeDefCb.setName(type + "TypeDefs");
        }

        JComponent getLeft() {
            return this.typeCb;
        }

        JComponent getRight() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 2));
            panel.add(Box.createHorizontalGlue());
            panel.add((Component)this.typeDefCb);
            panel.add(Box.createHorizontalGlue());
            return panel;
        }

        void init(DtTypeFilter typeFilter) {
            this.typeCb.setSelected(typeFilter.isTypeActive());
            this.typeDefCb.setSelected(typeFilter.isTypeDefActive());
        }

        DtTypeFilter getFilter() {
            DtTypeFilter filter = new DtTypeFilter(this.type);
            filter.setTypeActive(this.typeCb.isSelected());
            filter.setTypeDefActive(this.typeDefCb.isSelected());
            return filter;
        }
    }
}

