/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.util.TraceEvent;

public class TraceChangeRecord<T, U>
extends DomainObjectChangeRecord {
    private static final long serialVersionUID = 1L;
    private final AddressSpace space;
    private final T affectedObject;
    private final boolean oldKnown;

    public TraceChangeRecord(TraceEvent<T, U> type, AddressSpace space, T affectedObject, U oldValue, U newValue) {
        super(type, oldValue, newValue);
        this.space = space;
        this.affectedObject = affectedObject;
        this.oldKnown = true;
    }

    public TraceChangeRecord(TraceEvent<T, U> type, AddressSpace space, T affectedObject, U newValue) {
        super(type, null, newValue);
        this.space = space;
        this.affectedObject = affectedObject;
        this.oldKnown = false;
    }

    public TraceChangeRecord(TraceEvent<T, U> type, AddressSpace space, T affectedObject) {
        super(type, null, null);
        this.space = space;
        this.affectedObject = affectedObject;
        this.oldKnown = false;
    }

    public TraceChangeRecord(TraceEvent<T, U> type, AddressSpace space) {
        super(type, null, null);
        this.space = space;
        this.affectedObject = null;
        this.oldKnown = false;
    }

    public AddressSpace getAddressSpace() {
        return this.space;
    }

    public T getAffectedObject() {
        return this.affectedObject;
    }

    public boolean isOldKnown() {
        return this.oldKnown;
    }

    public U getOldValue() {
        return (U)super.getOldValue();
    }

    public U getNewValue() {
        return (U)super.getNewValue();
    }
}

