/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target.visitors;

import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.PathFilter;
import java.util.stream.Stream;

public class AncestorsRootVisitor
implements TreeTraversal.SpanIntersectingVisitor {
    protected final PathFilter filter;

    public AncestorsRootVisitor(PathFilter filter) {
        this.filter = filter;
    }

    @Override
    public TraceObjectValPath composePath(TraceObjectValPath pre, TraceObjectValue value) {
        return pre == null ? TraceObjectValPath.of() : pre.prepend(value);
    }

    @Override
    public TreeTraversal.VisitResult visitValue(TraceObjectValue value, TraceObjectValPath path) {
        return TreeTraversal.VisitResult.result(this.filter.matches(value.getParent().getCanonicalPath()), true);
    }

    @Override
    public TraceObject continueObject(TraceObjectValue value) {
        return value.getParent();
    }

    @Override
    public Stream<? extends TraceObjectValue> continueValues(TraceObject object, Lifespan span, TraceObjectValPath path) {
        if (object.isRoot()) {
            return Stream.empty();
        }
        return object.getParents(span).stream().filter(v -> !path.contains((TraceObjectValue)v));
    }
}

