/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.sublayout;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jungrapht.visualization.sublayout.Collapser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCollapser<V, E>
implements Collapser<V, E> {
    private static final Logger log = LoggerFactory.getLogger(GraphCollapser.class);
    protected Graph<V, E> graph;
    protected Graph<V, E> originalGraph;
    protected GraphTypeBuilder<V, E> graphTypeBuilder;
    protected final Map<V, Graph<V, E>> vertexToClusterMap = new HashMap<V, Graph<V, E>>();

    public GraphCollapser(Graph<V, E> graph) {
        this.graph = graph;
        this.setGraph(graph);
    }

    protected void setGraph(Graph<V, E> graph) {
        this.graph = graph;
        this.graphTypeBuilder = GraphTypeBuilder.forGraphType((GraphType)graph.getType()).allowingMultipleEdges(true).allowingSelfLoops(true);
        this.originalGraph = this.copyGraph(graph);
    }

    protected Graph<V, E> copyGraph(Graph<V, E> graph) {
        Graph originalGraphCopy = this.graphTypeBuilder.buildGraph();
        graph.vertexSet().forEach(arg_0 -> ((Graph)originalGraphCopy).addVertex(arg_0));
        graph.edgeSet().forEach(e -> originalGraphCopy.addEdge(graph.getEdgeSource(e), graph.getEdgeTarget(e), e));
        return originalGraphCopy;
    }

    @Override
    public Function<V, Graph<V, E>> collapsedGraphFunction() {
        return this.vertexToClusterMap::get;
    }

    @Override
    public Map<V, Graph<V, E>> getCollapsedGraphMap() {
        return Collections.unmodifiableMap(this.vertexToClusterMap);
    }

    @Override
    public V collapse(Collection<V> selected, Function<Collection<V>, V> vertexFunction) {
        return this.collapse(this.getClusterGraph(selected), vertexFunction);
    }

    V collapse(Graph<V, E> clusterGraph, Function<Collection<V>, V> vertexFunction) {
        if (clusterGraph.vertexSet().size() < 2) {
            return null;
        }
        V clusterVertex = vertexFunction.apply(clusterGraph.vertexSet());
        this.vertexToClusterMap.put((Graph<V, E>)clusterVertex, (Graph<Graph<V, E>, E>)clusterGraph);
        HashSet clusterVertices = new HashSet(clusterGraph.vertexSet());
        HashSet clusterEdges = new HashSet(clusterGraph.edgeSet());
        clusterEdges.stream().forEach(arg_0 -> this.graph.removeEdge(arg_0));
        clusterVertices.stream().forEach(arg_0 -> this.graph.removeVertex(arg_0));
        this.graph.addVertex(clusterVertex);
        Collection edgesToRestore = this.originalGraph.edgeSet().stream().filter(e -> !this.edgeInCluster(this.graph, e)).filter(e -> !clusterEdges.contains(e)).filter(e -> !this.graph.containsEdge(e)).collect(Collectors.toSet());
        if (log.isTraceEnabled()) {
            log.trace("originalGraph: {}", this.originalGraph);
            log.trace("edgesToRestore: {}", (Object)edgesToRestore);
            log.trace("edges not to restore: {}", this.originalGraph.edgeSet().stream().filter(clusterEdges::contains).filter(this.graph.edgeSet()::contains).collect(Collectors.toSet()));
        }
        for (Object e2 : edgesToRestore) {
            Graph<V, E> clusterGrp;
            Object source = this.originalGraph.getEdgeSource(e2);
            Object target = this.originalGraph.getEdgeTarget(e2);
            if (this.graph.containsVertex(source)) {
                if (!this.graph.containsVertex(target)) {
                    target = clusterVertex;
                    this.graph.addEdge(source, target, e2);
                    continue;
                }
                for (Object v : this.graph.vertexSet()) {
                    if (!this.vertexToClusterMap.containsKey(v) || !this.isVertexContainedInClusterGraph(clusterGrp = this.vertexToClusterMap.get(v), target)) continue;
                    target = v;
                    this.graph.addEdge(source, target, e2);
                }
                continue;
            }
            if (this.graph.containsVertex(target)) {
                if (!this.graph.containsVertex(source)) {
                    source = clusterVertex;
                    this.graph.addEdge(source, target, e2);
                    continue;
                }
                for (Object v : this.graph.vertexSet()) {
                    if (!this.vertexToClusterMap.containsKey(v) || !this.isVertexContainedInClusterGraph(clusterGrp = this.vertexToClusterMap.get(v), source)) continue;
                    source = v;
                    this.graph.addEdge(source, target, e2);
                }
                continue;
            }
            boolean foundSource = false;
            boolean foundTarget = false;
            for (Object v : this.graph.vertexSet()) {
                if (!this.vertexToClusterMap.containsKey(v)) continue;
                clusterGraph = this.vertexToClusterMap.get(v);
                if (this.isVertexContainedInClusterGraph(clusterGraph, source)) {
                    source = v;
                    foundSource = true;
                }
                if (!this.isVertexContainedInClusterGraph(clusterGraph, target)) continue;
                target = v;
                foundTarget = true;
            }
            if (!foundSource || !foundTarget) continue;
            this.graph.addEdge(source, target, e2);
        }
        return clusterVertex;
    }

    @Override
    public void expand(V clusterVertex) {
        this.expand((Collection<V>)Collections.singleton(clusterVertex));
    }

    @Override
    public void expand(Collection<V> clusterVertices) {
        for (V clusterVertex : clusterVertices) {
            if (this.vertexToClusterMap.containsKey(clusterVertex)) {
                Graph<V, E> subGraph = this.vertexToClusterMap.get(clusterVertex);
                this.graph.removeVertex(clusterVertex);
                subGraph.vertexSet().forEach(arg_0 -> this.graph.addVertex(arg_0));
                subGraph.edgeSet().forEach(e -> this.graph.addEdge(subGraph.getEdgeSource(e), subGraph.getEdgeTarget(e), e));
                Collection edgesIWant = this.originalGraph.edgeSet().stream().filter(e -> !this.graph.containsEdge(e)).filter(e -> !this.edgeInCluster(this.graph, e)).collect(Collectors.toSet());
                block1: for (Object e2 : edgesIWant) {
                    Graph<V, E> clusterGraph;
                    Object source = this.originalGraph.getEdgeSource(e2);
                    Object target = this.originalGraph.getEdgeTarget(e2);
                    if (this.graph.containsVertex(source) && this.graph.containsVertex(target)) {
                        this.graph.addEdge(source, target, e2);
                        continue;
                    }
                    if (this.graph.containsVertex(source)) {
                        Object originalTarget = this.originalGraph.getEdgeTarget(e2);
                        if (this.graph.containsVertex(originalTarget)) {
                            this.graph.addEdge(source, originalTarget, e2);
                            continue;
                        }
                        for (Object v : this.graph.vertexSet()) {
                            if (!this.vertexToClusterMap.containsKey(v) || !this.isVertexContainedInClusterGraph(clusterGraph = this.vertexToClusterMap.get(v), originalTarget)) continue;
                            this.graph.addEdge(source, v, e2);
                            continue block1;
                        }
                        continue;
                    }
                    if (this.graph.containsVertex(target)) {
                        Object originalSource = this.originalGraph.getEdgeSource(e2);
                        if (this.graph.containsVertex(originalSource)) {
                            this.graph.addEdge(source, originalSource, e2);
                            continue;
                        }
                        for (Object v : this.graph.vertexSet()) {
                            if (!this.vertexToClusterMap.containsKey(v) || !this.isVertexContainedInClusterGraph(clusterGraph = this.vertexToClusterMap.get(v), originalSource)) continue;
                            this.graph.addEdge(v, target, e2);
                            continue block1;
                        }
                        continue;
                    }
                    boolean foundSource = false;
                    boolean foundTarget = false;
                    for (Object v : this.graph.vertexSet()) {
                        if (!this.vertexToClusterMap.containsKey(v)) continue;
                        Graph<V, E> clusterGraph2 = this.vertexToClusterMap.get(v);
                        if (this.isVertexContainedInClusterGraph(clusterGraph2, source)) {
                            source = v;
                            foundSource = true;
                        }
                        if (!this.isVertexContainedInClusterGraph(clusterGraph2, target)) continue;
                        target = v;
                        foundTarget = true;
                    }
                    if (!foundSource || !foundTarget) continue;
                    this.graph.addEdge(source, target, e2);
                }
            }
            this.vertexToClusterMap.remove(clusterVertex);
        }
    }

    private boolean edgeInCluster(Graph<V, E> graph, E edge) {
        if (graph.containsEdge(edge)) {
            return true;
        }
        for (Object v : graph.vertexSet()) {
            Graph<V, E> collapsedGraph;
            if (!this.vertexToClusterMap.containsKey(v) || !this.edgeInCluster(collapsedGraph = this.vertexToClusterMap.get(v), edge)) continue;
            return true;
        }
        return false;
    }

    private String printGraph(StringBuilder buf, Graph<V, E> graph) {
        buf.append(graph.toString());
        buf.append("\n");
        for (Object v : graph.vertexSet()) {
            Graph<V, E> sub = this.vertexToClusterMap.get(v);
            if (sub == null) continue;
            this.printGraph(buf, sub);
        }
        return buf.toString();
    }

    private boolean isVertexContainedInClusterGraph(Graph<V, E> clusterGraph, V vertex) {
        if (clusterGraph.containsVertex(vertex)) {
            return true;
        }
        for (Object v : clusterGraph.vertexSet()) {
            Graph<V, E> subGraph;
            if (!this.vertexToClusterMap.containsKey(v) || !this.isVertexContainedInClusterGraph(subGraph = this.vertexToClusterMap.get(v), vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V findOwnerOf(V vertex) {
        for (Map.Entry<V, Graph<V, E>> entry : this.vertexToClusterMap.entrySet()) {
            if (!this.isVertexContainedInClusterGraph(entry.getValue(), vertex)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Graph<V, E> getClusterGraph(Collection<V> picked) {
        Graph clusterGraph = this.graphTypeBuilder.buildGraph();
        for (V vertex : picked) {
            clusterGraph.addVertex(vertex);
            Set edges = this.graph.edgesOf(vertex);
            for (Object edge : edges) {
                Object u = this.graph.getEdgeSource(edge);
                Object v = this.graph.getEdgeTarget(edge);
                if (!picked.contains(u) || !picked.contains(v)) continue;
                clusterGraph.addVertex(u);
                clusterGraph.addVertex(v);
                clusterGraph.addEdge(u, v, edge);
            }
        }
        return clusterGraph;
    }
}

