/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;

public interface PcodeStateCallbacks {
    public static final PcodeStateCallbacks NONE = NoPcodeStateCallbacks.INSTANCE;

    public static AddressSet rngSet(AddressSpace space, long offset, int length) {
        Address min = space.getAddress(offset);
        return new AddressSet(min, min.add((long)(length - 1)));
    }

    public static <A, T> PcodeExecutorStatePiece<A, T> checkValueDomain(PcodeExecutorStatePiece<A, ?> piece, Class<T> domain) {
        if (piece.getArithmetic().getDomain() == domain) {
            return piece;
        }
        return null;
    }

    default public <A, T> void dataWritten(PcodeExecutorStatePiece<A, T> piece, AddressSpace space, A offset, int length, T value) {
    }

    default public <A, T> void delegateDataWritten(PcodeExecutorStatePiece<A, T> piece, AddressSpace space, A offset, int length, T value) {
        this.dataWritten(piece, piece.getAddressArithmetic().toAddress(offset, space, PcodeArithmetic.Purpose.STORE), length, value);
    }

    default public <A, T> void dataWritten(PcodeExecutorStatePiece<A, T> piece, Address address, int length, T value) {
    }

    default public <A, T> void delegateDataWritten(PcodeExecutorStatePiece<A, T> piece, Address address, int length, T value) {
        this.dataWritten(piece, address.getAddressSpace(), piece.getAddressArithmetic().fromConst(address), length, value);
    }

    default public <A, T> int readUninitialized(PcodeExecutorStatePiece<A, T> piece, AddressSpace space, A offset, int length) {
        return 0;
    }

    default public <A, T> int delegateReadUninitialized(PcodeExecutorStatePiece<A, T> piece, AddressSpace space, A offset, int length) {
        AddressSetView remains;
        long lOffset = piece.getAddressArithmetic().toLong(offset, PcodeArithmetic.Purpose.LOAD);
        AddressSet set = PcodeStateCallbacks.rngSet(space, lOffset, length);
        if (set == (remains = this.readUninitialized(piece, (AddressSetView)set))) {
            return 0;
        }
        set.delete(remains);
        AddressRange first = set.getFirstRange();
        return first == null ? 0 : (int)first.getLength();
    }

    default public <A, T> AddressSetView readUninitialized(PcodeExecutorStatePiece<A, T> piece, AddressSetView set) {
        return set;
    }

    default public <A, T> AddressSetView delegateReadUninitialized(PcodeExecutorStatePiece<A, T> piece, AddressSetView set) {
        if (set.isEmpty()) {
            return set;
        }
        AddressSet remains = new AddressSet(set);
        for (AddressRange range : set) {
            int l = this.readUninitialized(piece, range.getAddressSpace(), piece.getAddressArithmetic().fromConst(range.getMinAddress()), (int)range.getLength());
            if (l == 0) continue;
            remains.delete(range.getMinAddress(), range.getMinAddress().add((long)(l - 1)));
        }
        return remains;
    }

    public static enum NoPcodeStateCallbacks implements PcodeStateCallbacks
    {
        INSTANCE;

    }
}

