/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.op.JitCatenateOp;
import ghidra.pcode.emu.jit.op.JitDefOp;
import ghidra.pcode.emu.jit.op.JitLoadOp;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.pcode.emu.jit.op.JitStoreOp;
import ghidra.pcode.emu.jit.op.JitSynthSubPieceOp;
import ghidra.pcode.emu.jit.var.JitConstVal;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.emu.jit.var.JitVarnodeVar;
import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.opbehavior.OpBehaviorFactory;
import ghidra.pcode.opbehavior.OpBehaviorSubpiece;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class JitDataFlowArithmetic
implements PcodeArithmetic<JitVal> {
    private static final OpBehaviorSubpiece OB_SUBPIECE = (OpBehaviorSubpiece)OpBehaviorFactory.getOpBehavior(63);
    private final JitDataFlowModel dfm;
    private final Endian endian;

    public JitDataFlowArithmetic(JitAnalysisContext context, JitDataFlowModel dfm) {
        this.dfm = dfm;
        this.endian = context.getEndian();
    }

    @Override
    public Class<JitVal> getDomain() {
        return JitVal.class;
    }

    @Override
    public Endian getEndian() {
        return this.endian;
    }

    public Varnode truncVnFromRight(Varnode vn, int amt) {
        return new Varnode(vn.getAddress(), vn.getSize() - amt);
    }

    public JitVal truncFromRight(Varnode in1Vn, int amt, JitVal in1) {
        Varnode outVn = this.truncVnFromRight(in1Vn, amt);
        return this.subpiece(outVn, this.endian.isBigEndian() ? amt : 0, in1);
    }

    public Varnode truncVnFromLeft(Varnode vn, int amt) {
        return new Varnode(vn.getAddress().add((long)amt), vn.getSize() - amt);
    }

    public JitVal truncFromLeft(Varnode in1Vn, int amt, JitVal in1) {
        Varnode outVn = this.truncVnFromLeft(in1Vn, amt);
        return this.subpiece(outVn, this.endian.isBigEndian() ? 0 : amt, in1);
    }

    private void removeOffsetFromRight(List<JitVal> parts, int offset) {
        JitVal p;
        while ((offset -= (p = parts.remove(parts.size() - 1)).size()) > 0) {
        }
        if (offset < 0) {
            JitVal np = this.shaveFromRight(-offset, p);
            parts.add(np);
            assert ((offset += np.size()) == 0);
        }
    }

    private void removeFromLeftToSize(List<JitVal> parts, int size) {
        JitVal p;
        int actualSize = 0;
        int i = parts.size();
        while ((actualSize += (p = parts.get(--i)).size()) < size) {
        }
        if (actualSize > size) {
            JitVal np = this.shaveFromLeft(-size, p);
            parts.set(i + 1, np);
            actualSize -= p.size();
            assert ((actualSize += np.size()) == size);
        }
        while (i > 0) {
            parts.remove(--i);
        }
    }

    private JitVal trySimplifiedSubPiece(JitOutVar out, int offset, JitVal v) {
        if (!(v instanceof JitOutVar)) {
            return null;
        }
        JitOutVar vOut = (JitOutVar)v;
        JitDefOp jitDefOp = vOut.definition();
        if (jitDefOp instanceof JitSynthSubPieceOp) {
            JitSynthSubPieceOp subsub = (JitSynthSubPieceOp)jitDefOp;
            subsub.unlink();
            return this.dfm.notifyOp(new JitSynthSubPieceOp(out, offset + subsub.offset(), subsub.v())).out();
        }
        jitDefOp = vOut.definition();
        if (jitDefOp instanceof JitCatenateOp) {
            JitCatenateOp cat = (JitCatenateOp)jitDefOp;
            cat.unlink();
            ArrayList<JitVal> newParts = new ArrayList<JitVal>(cat.parts());
            this.removeOffsetFromRight(newParts, offset);
            this.removeFromLeftToSize(newParts, out.size());
            assert (!newParts.isEmpty());
            if (newParts.size() == 1) {
                return (JitVal)newParts.get(0);
            }
            return this.dfm.notifyOp(new JitCatenateOp(out, newParts)).out();
        }
        return null;
    }

    private JitVal subpiece(Varnode outVn, int offset, JitVal v) {
        JitOutVar out = this.dfm.generateOutVar(outVn);
        JitVal simplified = this.trySimplifiedSubPiece(out, offset, v);
        if (simplified != null) {
            return simplified;
        }
        return this.dfm.notifyOp(new JitSynthSubPieceOp(out, offset, v)).out();
    }

    private Varnode subPieceVn(int size, int offset, Varnode whole) {
        if (this.endian.isBigEndian()) {
            return new Varnode(whole.getAddress().add((long)(whole.getSize() - offset - size)), size);
        }
        return new Varnode(whole.getAddress().add((long)offset), size);
    }

    public JitVal shaveFromRight(int amt, JitVal in1) {
        return this.subpiece(in1.size() - amt, amt, in1);
    }

    public JitVal shaveFromLeft(int amt, JitVal in1) {
        return this.subpiece(in1.size() - amt, 0, in1);
    }

    public JitVal subpiece(int size, int offset, JitVal v) {
        if (v instanceof JitConstVal) {
            JitConstVal c = (JitConstVal)v;
            return new JitConstVal(size, OB_SUBPIECE.evaluateBinary(size, v.size(), c.value(), BigInteger.valueOf(offset)));
        }
        if (v instanceof JitVarnodeVar) {
            JitVarnodeVar vv = (JitVarnodeVar)v;
            Varnode inVn = vv.varnode();
            Varnode outVn = this.subPieceVn(size, offset, inVn);
            return this.subpiece(outVn, offset, v);
        }
        throw new UnsupportedOperationException("unsupported subpiece of " + String.valueOf(v));
    }

    public JitVal catenate(Varnode outVn, List<JitVal> parts) {
        return this.dfm.notifyOp(new JitCatenateOp(this.dfm.generateOutVar(outVn), parts)).out();
    }

    @Override
    public JitVal unaryOp(PcodeOp op, JitVal in1) {
        return this.dfm.notifyOp(JitOp.unOp(op, this.dfm.generateOutVar(op.getOutput()), in1)).out();
    }

    @Override
    public JitVal unaryOp(int opcode, int sizeout, int sizein1, JitVal in1) {
        throw new AssertionError();
    }

    @Override
    public JitVal binaryOp(PcodeOp op, JitVal in1, JitVal in2) {
        return this.dfm.notifyOp(JitOp.binOp(op, this.dfm.generateOutVar(op.getOutput()), in1, in2)).out();
    }

    @Override
    public JitVal binaryOp(int opcode, int sizeout, int sizein1, JitVal in1, int sizein2, JitVal in2) {
        throw new AssertionError();
    }

    @Override
    public JitVal modBeforeStore(PcodeOp op, AddressSpace space, JitVal inOffset, JitVal inValue) {
        return this.dfm.notifyOp(new JitStoreOp(op, space, inOffset, inValue)).value();
    }

    @Override
    public JitVal modBeforeStore(int sizeinOffset, AddressSpace space, JitVal inOffset, int sizeinValue, JitVal inValue) {
        throw new AssertionError();
    }

    @Override
    public JitVal modAfterLoad(PcodeOp op, AddressSpace space, JitVal inOffset, JitVal inValue) {
        return this.dfm.notifyOp(new JitLoadOp(op, this.dfm.generateOutVar(op.getOutput()), space, inOffset)).out();
    }

    @Override
    public JitVal modAfterLoad(int sizeinOffset, AddressSpace space, JitVal inOffset, int sizeinValue, JitVal inValue) {
        throw new AssertionError();
    }

    @Override
    public JitVal fromConst(byte[] value) {
        BigInteger bigVal = Utils.bytesToBigInteger((byte[])value, (int)value.length, (boolean)this.endian.isBigEndian(), (boolean)false);
        return JitVal.constant(value.length, bigVal);
    }

    @Override
    public byte[] toConcrete(JitVal value, PcodeArithmetic.Purpose purpose) {
        if (value instanceof JitConstVal) {
            JitConstVal c = (JitConstVal)value;
            return Utils.bigIntegerToBytes((BigInteger)c.value(), (int)c.size(), (boolean)this.endian.isBigEndian());
        }
        throw new ConcretionError("Cannot concretize " + String.valueOf(value), purpose);
    }

    @Override
    public long sizeOf(JitVal value) {
        return value.size();
    }
}

