/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.util.Comparator;

public class MathUtilities {
    private MathUtilities() {
    }

    public static long unsignedDivide(long numerator, long denominator) {
        if (denominator < 0L) {
            throw new IllegalArgumentException("denomintor too big");
        }
        if (numerator >= 0L) {
            return numerator / denominator;
        }
        long numeratorDiv2 = numerator >>> 1;
        long result = numeratorDiv2 / denominator << 1;
        long remainder = numeratorDiv2 % denominator << 1;
        if ((remainder += numerator & 1L) >= denominator) {
            ++result;
        }
        return result;
    }

    public static long unsignedModulo(long numerator, long denominator) {
        if (denominator < 0L) {
            throw new IllegalArgumentException("denomintor too big");
        }
        if (numerator >= 0L) {
            return numerator % denominator;
        }
        long numeratorDiv2 = numerator >>> 1;
        long remainder = numeratorDiv2 % denominator << 1;
        return (remainder += numerator & 1L) % denominator;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static void main(String[] args) {
        long d = 4L;
        for (long i = 27L; i > -27L; --i) {
            long result = MathUtilities.unsignedDivide(i, d);
            long mod = MathUtilities.unsignedModulo(i, d);
            long v = result * d + mod;
            System.out.println("0x" + Long.toHexString(i) + " -> 0x" + Long.toHexString(result) + ":0x" + Long.toHexString(mod) + " -> 0x" + Long.toHexString(v));
        }
    }

    public static long unsignedMin(long a, long b) {
        return Long.compareUnsigned(a, b) < 0 ? a : b;
    }

    public static int unsignedMin(int a, int b) {
        return Integer.compareUnsigned(a, b) < 0 ? a : b;
    }

    public static int unsignedMin(int a, long b) {
        return Long.compareUnsigned((long)a & 0xFFFFFFFFL, b) < 0 ? a : (int)b;
    }

    public static int unsignedMin(long a, int b) {
        return Long.compareUnsigned(a, (long)b & 0xFFFFFFFFL) < 0 ? (int)a : b;
    }

    public static long unsignedMax(long a, long b) {
        return Long.compareUnsigned(a, b) > 0 ? a : b;
    }

    public static int unsignedMax(int a, int b) {
        return Integer.compareUnsigned(a, b) > 0 ? a : b;
    }

    public static long unsignedMax(int a, long b) {
        return Long.compareUnsigned((long)a & 0xFFFFFFFFL, b) > 0 ? (long)a : b;
    }

    public static long unsignedMax(long a, int b) {
        return Long.compareUnsigned(a, (long)b & 0xFFFFFFFFL) > 0 ? a : (long)b;
    }

    public static <C> C cmin(C a, C b, Comparator<C> comp) {
        return comp.compare(a, b) <= 0 ? a : b;
    }

    public static <C extends Comparable<C>> C cmin(C a, C b) {
        return MathUtilities.cmin(a, b, Comparator.naturalOrder());
    }

    public static <C> C cmax(C a, C b, Comparator<C> comp) {
        return comp.compare(a, b) >= 0 ? a : b;
    }

    public static <C extends Comparable<C>> C cmax(C a, C b) {
        return MathUtilities.cmax(a, b, Comparator.naturalOrder());
    }
}

