/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.ActionContext;
import ghidra.app.plugin.core.debug.gui.control.TargetActionTask;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.PathTableModel;
import ghidra.app.services.DebuggerListingService;
import ghidra.debug.api.model.DebuggerSingleObjectPathActionContext;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.iface.TraceActivatable;
import ghidra.trace.model.target.iface.TraceTogglable;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.util.Msg;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;

public interface ObjectDefaultActionsMixin {
    public PluginTool getTool();

    public DebuggerCoordinates getCurrent();

    public void activatePath(KeyPath var1);

    default public void toggleObject(TraceObject object) {
        if (!this.getCurrent().isAliveAndPresent()) {
            return;
        }
        Target target = this.getCurrent().getTarget();
        Map actions = target.collectActions(ActionName.TOGGLE, (ActionContext)new DebuggerSingleObjectPathActionContext(object.getCanonicalPath()), Target.ObjectArgumentPolicy.CONTEXT_ONLY);
        Target.ActionEntry action = actions.values().stream().filter(e -> !e.requiresPrompt()).sorted(Comparator.comparing(e -> -e.specificity())).findFirst().orElse(null);
        if (action == null) {
            Msg.error((Object)this, (Object)("No suitable toggle action for " + String.valueOf(object)));
            return;
        }
        TargetActionTask.runAction(this.getTool(), "Toggle", action);
    }

    default public void goToAddress(DebuggerListingService listingService, Address address) {
        ProgramLocation loc = new ProgramLocation((Program)this.getCurrent().getView(), address);
        listingService.goTo(loc, true);
    }

    default public void goToAddress(Address address) {
        DebuggerListingService listingService = (DebuggerListingService)this.getTool().getService(DebuggerListingService.class);
        if (listingService == null) {
            return;
        }
        this.goToAddress(listingService, address);
    }

    default public void goToRange(AddressRange range) {
        DebuggerListingService listingService = (DebuggerListingService)this.getTool().getService(DebuggerListingService.class);
        if (listingService == null) {
            return;
        }
        listingService.setCurrentSelection(new ProgramSelection(range.getMinAddress(), range.getMaxAddress()));
        this.goToAddress(listingService, range.getMinAddress());
    }

    default public boolean performElementCellDefaultAction(JTable table) {
        ObjectTableModel.ValueProperty property;
        Object propValue;
        int col;
        int row = table.getSelectedRow();
        Object cellValue = table.getValueAt(row, col = table.getSelectedColumn());
        return cellValue instanceof ObjectTableModel.ValueProperty && this.performDefaultAction(propValue = (property = (ObjectTableModel.ValueProperty)cellValue).getValue());
    }

    default public boolean performValueRowDefaultAction(ObjectTableModel.ValueRow row) {
        if (row == null) {
            return false;
        }
        return this.performDefaultAction(row.getValue());
    }

    default public boolean performPathRowDefaultAction(PathTableModel.PathRow row) {
        if (row == null) {
            return false;
        }
        return this.performDefaultAction(row.getValue());
    }

    default public boolean performDefaultAction(TraceObjectValue value) {
        if (value == null) {
            return false;
        }
        return this.performDefaultAction(value.getValue());
    }

    default public boolean performDefaultAction(TraceObject object) {
        Object object2;
        Object object3;
        Set interfaces = object.getSchema().getInterfaces();
        if (interfaces.contains(TraceActivatable.class)) {
            this.activatePath(object.getCanonicalPath());
            return true;
        }
        if (interfaces.contains(TraceTogglable.class)) {
            this.toggleObject(object);
            return true;
        }
        long snap = this.getCurrent().getSnap();
        TraceObjectValue valAddress = object.getAttribute(snap, "_address");
        if (valAddress != null && (object3 = valAddress.getValue()) instanceof Address) {
            Address address = (Address)object3;
            this.goToAddress(address);
            return true;
        }
        TraceObjectValue valRange = object.getAttribute(snap, "_range");
        if (valRange != null && (object2 = valRange.getValue()) instanceof AddressRange) {
            AddressRange range = (AddressRange)object2;
            this.goToRange(range);
            return true;
        }
        return false;
    }

    default public boolean performDefaultAction(Object value) {
        if (value instanceof Address) {
            Address address = (Address)value;
            this.goToAddress(address);
            return true;
        }
        if (value instanceof AddressRange) {
            AddressRange range = (AddressRange)value;
            this.goToRange(range);
            return true;
        }
        if (value instanceof TraceObject) {
            TraceObject object = (TraceObject)value;
            return this.performDefaultAction(object);
        }
        return false;
    }
}

