/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import ghidra.docking.settings.BooleanSettingsDefinition;
import ghidra.docking.settings.Settings;

public class ShowNamespaceSettingsDefinition
implements BooleanSettingsDefinition {
    public static final ShowNamespaceSettingsDefinition DEF = new ShowNamespaceSettingsDefinition();
    private static final boolean DEFAULT = true;
    private static final String DESCRIPTION = "Toggles showing namespace when displaying function name";
    private static final String SHOW_NAMESPACE = "Show Namespace";

    public boolean getValue(Settings settings) {
        if (settings == null) {
            return true;
        }
        String value = settings.getString(SHOW_NAMESPACE);
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public String getValueString(Settings settings) {
        return Boolean.toString(this.getValue(settings));
    }

    public void setValue(Settings settings, boolean value) {
        settings.setString(SHOW_NAMESPACE, Boolean.toString(value));
    }

    public void copySetting(Settings srcSettings, Settings destSettings) {
        String value = srcSettings.getString(SHOW_NAMESPACE);
        if (value == null) {
            destSettings.clearSetting(SHOW_NAMESPACE);
        } else {
            destSettings.setString(SHOW_NAMESPACE, value);
        }
    }

    public void clear(Settings settings) {
        settings.clearSetting(SHOW_NAMESPACE);
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return SHOW_NAMESPACE;
    }

    public String getStorageKey() {
        return SHOW_NAMESPACE;
    }

    public boolean hasValue(Settings settings) {
        return settings.getValue(SHOW_NAMESPACE) != null;
    }
}

