/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.HighlightToken;
import java.util.Objects;

class TokenKey {
    private ClangToken token;
    private int hash;
    private int lineNumber = -1;
    private int indexInParent = Integer.MAX_VALUE;

    TokenKey(ClangToken token) {
        this.token = Objects.requireNonNull(token);
        ClangLine lineParent = token.getLineParent();
        if (lineParent != null) {
            this.lineNumber = lineParent.getLineNumber();
        }
        this.hash = Objects.hash(token.getText());
        this.hash += this.lineNumber;
    }

    public TokenKey(HighlightToken t) {
        this(t.getToken());
    }

    private int getIndexInParent() {
        if (this.indexInParent == Integer.MAX_VALUE) {
            ClangLine lineParent = this.token.getLineParent();
            this.indexInParent = lineParent != null ? lineParent.indexOfToken(this.token) : -1;
        }
        return this.indexInParent;
    }

    public ClangToken getToken() {
        return this.token;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TokenKey otherKey = (TokenKey)obj;
        ClangToken otherToken = otherKey.token;
        if (this.token.getClass() != otherToken.getClass()) {
            return false;
        }
        if (!Objects.equals(this.token.getText(), otherToken.getText())) {
            return false;
        }
        if (this.lineNumber != otherKey.lineNumber) {
            return false;
        }
        return this.getIndexInParent() == otherKey.getIndexInParent();
    }

    public String toString() {
        return this.token.toString();
    }
}

