/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13Type;
import ghidra.app.util.bin.format.pdb2.pdbreader.CoffSymbolRvaC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.CrossScopeExportsC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.CrossScopeImportsC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.FileChecksumsC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.FrameDataC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.FuncMdTokenMapC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.IlLinesC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.InlineeLinesC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.LinesC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.MergedAssemblyInputC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderUtils;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringTableC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolsC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeMdTokenMapC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.UnknownC13Section;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;

public abstract class C13Section {
    private boolean ignore;

    protected C13Section(boolean ignore) {
        this.ignore = ignore;
    }

    boolean ignore() {
        return this.ignore;
    }

    void dump(Writer writer, TaskMonitor monitor) throws IOException, CancelledException {
        PdbReaderUtils.dumpHead(writer, this);
        this.dumpInternal(writer, monitor);
        PdbReaderUtils.dumpTail(writer, this);
    }

    protected abstract void dumpInternal(Writer var1, TaskMonitor var2) throws IOException, CancelledException;

    static C13Section parse(PdbByteReader reader, TaskMonitor monitor) throws CancelledException, PdbException {
        int typeVal = reader.parseInt();
        boolean ignore = C13Type.ignore(typeVal);
        C13Type type = C13Type.fromValue(typeVal);
        int length = reader.parseInt();
        PdbByteReader recordReader = reader.getSubPdbByteReader(length);
        switch (type) {
            case SYMBOLS: {
                return SymbolsC13Section.parse(recordReader, ignore, monitor);
            }
            case LINES: {
                return LinesC13Section.parse(recordReader, ignore, monitor);
            }
            case STRING_TABLE: {
                return StringTableC13Section.parse(recordReader, ignore, monitor);
            }
            case FILE_CHECKSUMS: {
                return FileChecksumsC13Section.parse(recordReader, ignore, monitor);
            }
            case FRAMEDATA: {
                return FrameDataC13Section.parse(recordReader, ignore, monitor);
            }
            case INLINEE_LINES: {
                return InlineeLinesC13Section.parse(recordReader, ignore, monitor);
            }
            case CROSS_SCOPE_IMPORTS: {
                return CrossScopeImportsC13Section.parse(recordReader, ignore, monitor);
            }
            case CROSS_SCOPE_EXPORTS: {
                return CrossScopeExportsC13Section.parse(recordReader, ignore, monitor);
            }
            case IL_LINES: {
                return IlLinesC13Section.parse(recordReader, ignore, monitor);
            }
            case FUNC_MDTOKEN_MAP: {
                return FuncMdTokenMapC13Section.parse(recordReader, ignore, monitor);
            }
            case TYPE_MDTOKEN_MAP: {
                return TypeMdTokenMapC13Section.parse(recordReader, ignore, monitor);
            }
            case MERGED_ASSEMBLY_INPUT: {
                return MergedAssemblyInputC13Section.parse(recordReader, ignore, monitor);
            }
            case COFF_SYMBOL_RVA: {
                return CoffSymbolRvaC13Section.parse(recordReader, ignore, monitor);
            }
        }
        return UnknownC13Section.parse(recordReader, ignore, monitor);
    }
}

