/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.opinion.DexLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.file.formats.android.dex.DexHeaderFactory;
import ghidra.file.formats.android.dex.format.DexHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CDexLoader
extends DexLoader {
    @Override
    public String getName() {
        return "Compact Dalvik Executable (CDEX)";
    }

    public LoaderTier getTier() {
        return LoaderTier.UNTARGETED_LOADER;
    }

    public int getTierPriority() {
        return 100;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        BinaryReader reader = new BinaryReader(provider, true);
        try {
            DexHeader header;
            byte[] magicBytes = provider.readBytes(0L, (long)"cdex".length());
            if ("cdex".equals(new String(magicBytes)) && "cdex".equals(new String((header = DexHeaderFactory.getDexHeader(reader)).getMagic()))) {
                List queries = QueryOpinionService.query((String)this.getName(), (String)"1", null);
                for (QueryResult result : queries) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
                }
                if (loadSpecs.isEmpty()) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loadSpecs;
    }

    public boolean supportsLoadIntoProgram() {
        return true;
    }

    @Override
    protected String getMemoryBlockName() {
        return ".cdex";
    }

    @Override
    protected String getMonitorMessagePrimary() {
        return "CDEX Loader: creating cdex memory";
    }

    @Override
    protected String getMonitorMessageSecondary() {
        return "CDEX Loader: creating method byte code";
    }
}

