/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.nav.NavigationUtils;
import ghidra.app.plugin.core.debug.service.emulation.DebuggerEmulationIntegration;
import ghidra.app.plugin.core.debug.service.emulation.data.DefaultPcodeDebuggerAccess;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.pcode.exec.AbstractPcodeExecutorState;
import ghidra.pcode.exec.AddressesReadPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeExecutorState;
import ghidra.pcode.exec.LocationPcodeArithmetic;
import ghidra.pcode.exec.LocationPcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeExpression;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.exec.ValueLocation;
import ghidra.pcode.exec.trace.AddressesReadTracePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeArithmetic;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.pcode.utils.Utils;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeParser;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;
import ghidra.sleigh.grammar.Location;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.symbol.TraceSymbolWithLifespan;
import ghidra.util.NumericUtilities;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class DebuggerPcodeUtils
extends Enum<DebuggerPcodeUtils> {
    private static final /* synthetic */ DebuggerPcodeUtils[] $VALUES;

    public static DebuggerPcodeUtils[] values() {
        return (DebuggerPcodeUtils[])$VALUES.clone();
    }

    public static DebuggerPcodeUtils valueOf(String name) {
        return Enum.valueOf(DebuggerPcodeUtils.class, name);
    }

    public static PcodeProgram compileProgram(ServiceProvider provider, DebuggerCoordinates coordinates, String sourceName, String source, PcodeUseropLibrary<?> library) {
        return SleighProgramCompiler.compileProgram((PcodeParser)new LabelBoundPcodeParser(provider, coordinates), (SleighLanguage)((SleighLanguage)coordinates.getPlatform().getLanguage()), (String)sourceName, (String)source, library);
    }

    public static PcodeExpression compileExpression(ServiceProvider provider, DebuggerCoordinates coordinates, String source) {
        return SleighProgramCompiler.compileExpression((PcodeParser)new LabelBoundPcodeParser(provider, coordinates), (SleighLanguage)((SleighLanguage)coordinates.getPlatform().getLanguage()), (String)source);
    }

    public static PcodeExecutorState<byte[]> executorStateForCoordinates(ServiceProvider provider, DebuggerCoordinates coordinates) {
        Trace trace = coordinates.getTrace();
        if (trace == null) {
            throw new IllegalArgumentException("Coordinates have no trace");
        }
        TracePlatform platform = coordinates.getPlatform();
        Language language = platform.getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Given trace or platform does not use a Sleigh language");
        }
        SleighLanguage language2 = (SleighLanguage)language;
        DefaultPcodeDebuggerAccess access = new DefaultPcodeDebuggerAccess(provider, coordinates.getTarget(), platform, coordinates.getViewSnap());
        PcodeStateCallbacks cb = DebuggerEmulationIntegration.bytesImmediateWriteTarget(access, coordinates.getThread(), coordinates.getFrame());
        return new BytesPcodeExecutorState((Language)language2, cb);
    }

    public static PcodeExecutor<byte[]> executorForCoordinates(ServiceProvider provider, DebuggerCoordinates coordinates) {
        PcodeExecutorState<byte[]> state = DebuggerPcodeUtils.executorStateForCoordinates(provider, coordinates);
        SleighLanguage language = (SleighLanguage)state.getLanguage();
        return new PcodeExecutor(language, (PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)language), state, PcodeExecutorStatePiece.Reason.INSPECT);
    }

    public static WatchValuePcodeExecutorState buildWatchState(ServiceProvider provider, DebuggerCoordinates coordinates) {
        PcodeTraceDataAccess data = new DefaultPcodeTraceAccess(coordinates.getPlatform(), coordinates.getViewSnap(), coordinates.getSnap()).getDataForThreadState(coordinates.getThread(), coordinates.getFrame());
        PcodeExecutorState<byte[]> bytesState = DebuggerPcodeUtils.executorStateForCoordinates(provider, coordinates);
        return new WatchValuePcodeExecutorState(new WatchValuePcodeExecutorStatePiece((PcodeExecutorStatePiece<byte[], byte[]>)bytesState, (PcodeExecutorStatePiece<byte[], TraceMemoryState>)new TraceMemoryStatePcodeExecutorStatePiece(data), (PcodeExecutorStatePiece<byte[], ValueLocation>)new LocationPcodeExecutorStatePiece(data.getLanguage()), (PcodeExecutorStatePiece<byte[], AddressSetView>)new AddressesReadTracePcodeExecutorStatePiece(data)));
    }

    public static PcodeExecutor<WatchValue> buildWatchExecutor(ServiceProvider provider, DebuggerCoordinates coordinates) {
        TracePlatform platform = coordinates.getPlatform();
        Language language = platform.getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Watch expressions require a Sleigh language");
        }
        SleighLanguage slang = (SleighLanguage)language;
        WatchValuePcodeExecutorState state = DebuggerPcodeUtils.buildWatchState(provider, coordinates);
        return new PcodeExecutor(slang, state.getArithmetic(), (PcodeExecutorState)state, PcodeExecutorStatePiece.Reason.INSPECT);
    }

    private static /* synthetic */ DebuggerPcodeUtils[] $values() {
        return new DebuggerPcodeUtils[0];
    }

    static {
        $VALUES = DebuggerPcodeUtils.$values();
    }

    public static class LabelBoundPcodeParser
    extends SleighProgramCompiler.ErrorCollectingPcodeParser {
        private final DebuggerStaticMappingService mappings;
        private final DebuggerCoordinates coordinates;

        public LabelBoundPcodeParser(ServiceProvider provider, DebuggerCoordinates coordinates) {
            super((SleighLanguage)coordinates.getPlatform().getLanguage());
            this.mappings = (DebuggerStaticMappingService)provider.getService(DebuggerStaticMappingService.class);
            this.coordinates = coordinates;
        }

        protected SleighSymbol createSleighConstant(String sourceName, String nm, Address address) {
            return new VarnodeSymbol(new Location(sourceName, 0), nm, this.getConstantSpace(), address.getOffset(), address.getAddressSpace().getPointerSize());
        }

        public SleighSymbol findSymbol(String nm) {
            SleighSymbol symbol = null;
            try {
                symbol = super.findSymbol(nm);
            }
            catch (SleighException sleighException) {
                // empty catch block
            }
            if (symbol == null) {
                symbol = this.findUserSymbol(nm);
            }
            if (symbol == null) {
                throw new SleighException("Unknown register or label: '" + nm + "'");
            }
            return symbol;
        }

        protected SleighSymbol tryMap(String nm, Trace trace, long snap, Program program, Symbol symbol, Address addr, List<SleighSymbol> externals) {
            TraceLocation tloc = this.mappings.getOpenMappedLocation(trace, new ProgramLocation(program, addr), snap);
            if (tloc == null) {
                return null;
            }
            SleighSymbol mapped = this.createSleighConstant(program.getName(), nm, tloc.getAddress());
            if (!symbol.isExternal()) {
                return mapped;
            }
            externals.add(mapped);
            return null;
        }

        protected SleighSymbol tryExternalLinkage(String nm, Trace trace, long snap, Program program, Symbol symbol, List<SleighSymbol> externals) {
            Object object = symbol.getObject();
            if (!(object instanceof Function)) {
                return null;
            }
            Function func = (Function)object;
            Address[] extAddresses = NavigationUtils.getExternalLinkageAddresses((Program)program, (Address)symbol.getAddress());
            if (extAddresses == null) {
                return null;
            }
            for (Address addr : extAddresses) {
                SleighSymbol mapped = this.tryMap(nm, trace, snap, program, symbol, addr, externals);
                if (mapped == null) continue;
                return mapped;
            }
            return null;
        }

        protected SleighSymbol findUserSymbol(String nm) {
            Trace trace = this.coordinates.getTrace();
            long snap = this.coordinates.getSnap();
            for (TraceSymbol symbol : trace.getSymbolManager().labels().getNamed(nm)) {
                TraceSymbolWithLifespan lifeSym;
                if (symbol instanceof TraceSymbolWithLifespan && !(lifeSym = (TraceSymbolWithLifespan)symbol).getLifespan().contains(snap)) continue;
                return this.createSleighConstant(trace.getName(), nm, symbol.getAddress());
            }
            ArrayList<SleighSymbol> externals = new ArrayList<SleighSymbol>();
            for (Program program : this.mappings.getOpenMappedProgramsAtSnap(trace, snap)) {
                for (Symbol symbol : program.getSymbolTable().getSymbols(nm)) {
                    if (symbol.getSymbolType() != SymbolType.FUNCTION && symbol.getSymbolType() != SymbolType.LABEL) continue;
                    SleighSymbol mapped = this.tryMap(nm, trace, snap, program, symbol, symbol.getAddress(), externals);
                    if (mapped != null) {
                        return mapped;
                    }
                    mapped = this.tryExternalLinkage(nm, trace, snap, program, symbol, externals);
                    if (mapped == null) continue;
                    return mapped;
                }
            }
            Iterator iterator = externals.iterator();
            if (iterator.hasNext()) {
                SleighSymbol ext = (SleighSymbol)iterator.next();
                return ext;
            }
            return null;
        }

        record ProgSym(String sourceName, String nm, Address address) {
        }
    }

    public static class WatchValuePcodeExecutorState
    extends AbstractPcodeExecutorState<byte[], WatchValue> {
        public WatchValuePcodeExecutorState(PcodeExecutorStatePiece<byte[], WatchValue> piece) {
            super(piece);
        }

        protected byte[] extractAddress(WatchValue value) {
            return value.bytes.bytes;
        }

        public WatchValuePcodeExecutorState fork(PcodeStateCallbacks cb) {
            return new WatchValuePcodeExecutorState((PcodeExecutorStatePiece<byte[], WatchValue>)this.piece.fork(cb));
        }
    }

    public static class WatchValuePcodeExecutorStatePiece
    implements PcodeExecutorStatePiece<byte[], WatchValue> {
        private final PcodeExecutorStatePiece<byte[], byte[]> bytesPiece;
        private final PcodeExecutorStatePiece<byte[], TraceMemoryState> statePiece;
        private final PcodeExecutorStatePiece<byte[], ValueLocation> locationPiece;
        private final PcodeExecutorStatePiece<byte[], AddressSetView> readsPiece;
        private final PcodeArithmetic<WatchValue> arithmetic;

        public WatchValuePcodeExecutorStatePiece(PcodeExecutorStatePiece<byte[], byte[]> bytesPiece, PcodeExecutorStatePiece<byte[], TraceMemoryState> statePiece, PcodeExecutorStatePiece<byte[], ValueLocation> locationPiece, PcodeExecutorStatePiece<byte[], AddressSetView> readsPiece) {
            this.bytesPiece = bytesPiece;
            this.statePiece = statePiece;
            this.locationPiece = locationPiece;
            this.readsPiece = readsPiece;
            this.arithmetic = WatchValuePcodeArithmetic.forLanguage(bytesPiece.getLanguage());
        }

        public Language getLanguage() {
            return this.bytesPiece.getLanguage();
        }

        public PcodeArithmetic<byte[]> getAddressArithmetic() {
            return this.bytesPiece.getAddressArithmetic();
        }

        public PcodeArithmetic<WatchValue> getArithmetic() {
            return this.arithmetic;
        }

        public Stream<PcodeExecutorStatePiece<?, ?>> streamPieces() {
            return Stream.of(this.bytesPiece, this.statePiece, this.locationPiece, this.readsPiece);
        }

        public WatchValuePcodeExecutorStatePiece fork(PcodeStateCallbacks cb) {
            return new WatchValuePcodeExecutorStatePiece((PcodeExecutorStatePiece<byte[], byte[]>)this.bytesPiece.fork(cb), (PcodeExecutorStatePiece<byte[], TraceMemoryState>)this.statePiece.fork(cb), (PcodeExecutorStatePiece<byte[], ValueLocation>)this.locationPiece.fork(cb), (PcodeExecutorStatePiece<byte[], AddressSetView>)this.readsPiece.fork(cb));
        }

        public void setVarInternal(AddressSpace space, byte[] offset, int size, WatchValue val) {
            this.bytesPiece.setVarInternal(space, (Object)offset, size, (Object)val.bytes.bytes);
            this.statePiece.setVarInternal(space, (Object)offset, size, (Object)val.state);
            this.locationPiece.setVarInternal(space, (Object)offset, size, (Object)val.location);
            this.readsPiece.setVarInternal(space, (Object)offset, size, (Object)val.reads);
        }

        public void setVar(AddressSpace space, byte[] offset, int size, boolean quantize, WatchValue val) {
            this.bytesPiece.setVar(space, (Object)offset, size, quantize, (Object)val.bytes.bytes);
            this.statePiece.setVar(space, (Object)offset, size, quantize, (Object)val.state);
            this.locationPiece.setVar(space, (Object)offset, size, quantize, (Object)val.location);
            this.readsPiece.setVar(space, (Object)offset, size, quantize, (Object)val.reads);
        }

        public WatchValue getVar(AddressSpace space, byte[] offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
            return new WatchValue(new PrettyBytes(this.getLanguage().isBigEndian(), (byte[])this.bytesPiece.getVar(space, (Object)offset, size, quantize, reason)), (TraceMemoryState)this.statePiece.getVar(space, (Object)offset, size, quantize, reason), (ValueLocation)this.locationPiece.getVar(space, (Object)offset, size, quantize, reason), (AddressSetView)this.readsPiece.getVar(space, (Object)offset, size, quantize, reason));
        }

        public WatchValue getVarInternal(AddressSpace space, byte[] offset, int size, PcodeExecutorStatePiece.Reason reason) {
            return new WatchValue(new PrettyBytes(this.getLanguage().isBigEndian(), (byte[])this.bytesPiece.getVarInternal(space, (Object)offset, size, reason)), (TraceMemoryState)this.statePiece.getVarInternal(space, (Object)offset, size, reason), (ValueLocation)this.locationPiece.getVarInternal(space, (Object)offset, size, reason), (AddressSetView)this.readsPiece.getVarInternal(space, (Object)offset, size, reason));
        }

        public Map<Register, WatchValue> getRegisterValues() {
            HashMap<Register, WatchValue> result = new HashMap<Register, WatchValue>();
            for (Map.Entry entry : this.bytesPiece.getRegisterValues().entrySet()) {
                Register reg = (Register)entry.getKey();
                AddressSpace space = reg.getAddressSpace();
                long offset = reg.getAddress().getOffset();
                int size = reg.getNumBytes();
                result.put(reg, new WatchValue(new PrettyBytes(this.getLanguage().isBigEndian(), (byte[])entry.getValue()), (TraceMemoryState)this.statePiece.getVar(space, offset, size, false, PcodeExecutorStatePiece.Reason.INSPECT), (ValueLocation)this.locationPiece.getVar(space, offset, size, false, PcodeExecutorStatePiece.Reason.INSPECT), (AddressSetView)this.readsPiece.getVar(space, offset, size, false, PcodeExecutorStatePiece.Reason.INSPECT)));
            }
            return result;
        }

        public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
            return this.bytesPiece.getConcreteBuffer(address, purpose);
        }

        public void clear() {
            this.bytesPiece.clear();
            this.statePiece.clear();
            this.locationPiece.clear();
            this.readsPiece.clear();
        }
    }

    public static enum WatchValuePcodeArithmetic implements PcodeArithmetic<WatchValue>
    {
        BIG_ENDIAN(BytesPcodeArithmetic.BIG_ENDIAN, LocationPcodeArithmetic.BIG_ENDIAN),
        LITTLE_ENDIAN(BytesPcodeArithmetic.LITTLE_ENDIAN, LocationPcodeArithmetic.LITTLE_ENDIAN);

        private static final TraceMemoryStatePcodeArithmetic STATE;
        private static final AddressesReadPcodeArithmetic READS;
        private final BytesPcodeArithmetic bytes;
        private final LocationPcodeArithmetic location;

        public static WatchValuePcodeArithmetic forEndian(boolean isBigEndian) {
            return isBigEndian ? BIG_ENDIAN : LITTLE_ENDIAN;
        }

        public static WatchValuePcodeArithmetic forLanguage(Language language) {
            return WatchValuePcodeArithmetic.forEndian(language.isBigEndian());
        }

        private WatchValuePcodeArithmetic(BytesPcodeArithmetic bytes, LocationPcodeArithmetic location) {
            this.bytes = bytes;
            this.location = location;
        }

        public Class<WatchValue> getDomain() {
            return WatchValue.class;
        }

        public Endian getEndian() {
            return this.bytes.getEndian();
        }

        public WatchValue unaryOp(int opcode, int sizeout, int sizein1, WatchValue in1) {
            return new WatchValue(new PrettyBytes(this.getEndian().isBigEndian(), this.bytes.unaryOp(opcode, sizeout, sizein1, in1.bytes.bytes)), STATE.unaryOp(opcode, sizeout, sizein1, in1.state), this.location.unaryOp(opcode, sizeout, sizein1, in1.location), READS.unaryOp(opcode, sizeout, sizein1, in1.reads));
        }

        public WatchValue binaryOp(int opcode, int sizeout, int sizein1, WatchValue in1, int sizein2, WatchValue in2) {
            return new WatchValue(new PrettyBytes(this.getEndian().isBigEndian(), this.bytes.binaryOp(opcode, sizeout, sizein1, in1.bytes.bytes, sizein2, in2.bytes.bytes)), STATE.binaryOp(opcode, sizeout, sizein1, in1.state, sizein2, in2.state), this.location.binaryOp(opcode, sizeout, sizein1, in1.location, sizein2, in2.location), READS.binaryOp(opcode, sizeout, sizein1, in1.reads, sizein2, in2.reads));
        }

        public WatchValue modBeforeStore(int sizeinOffset, AddressSpace space, WatchValue inOffset, int sizeinValue, WatchValue inValue) {
            return new WatchValue(new PrettyBytes(inValue.bytes.bigEndian, this.bytes.modBeforeStore(sizeinOffset, space, inOffset.bytes.bytes, sizeinValue, inValue.bytes.bytes)), STATE.modBeforeStore(sizeinOffset, space, inOffset.state, sizeinValue, inValue.state), this.location.modBeforeStore(sizeinOffset, space, inOffset.location, sizeinValue, inValue.location), READS.modBeforeStore(sizeinOffset, space, inOffset.reads, sizeinValue, inValue.reads));
        }

        public WatchValue modAfterLoad(int sizeinOffset, AddressSpace space, WatchValue inOffset, int sizeinValue, WatchValue inValue) {
            return new WatchValue(new PrettyBytes(this.getEndian().isBigEndian(), this.bytes.modAfterLoad(sizeinOffset, space, inOffset.bytes.bytes, sizeinValue, inValue.bytes.bytes)), STATE.modAfterLoad(sizeinOffset, space, inOffset.state, sizeinValue, inValue.state), this.location.modAfterLoad(sizeinOffset, space, inOffset.location, sizeinValue, inValue.location), READS.modAfterLoad(sizeinOffset, space, inOffset.reads, sizeinValue, inValue.reads));
        }

        public WatchValue fromConst(byte[] value) {
            return new WatchValue(new PrettyBytes(this.getEndian().isBigEndian(), this.bytes.fromConst(value)), STATE.fromConst(value), this.location.fromConst(value), READS.fromConst(value));
        }

        public byte[] toConcrete(WatchValue value, PcodeArithmetic.Purpose purpose) {
            return this.bytes.toConcrete(value.bytes.bytes, purpose);
        }

        public long sizeOf(WatchValue value) {
            return this.bytes.sizeOf(value.bytes.bytes);
        }

        static {
            STATE = TraceMemoryStatePcodeArithmetic.INSTANCE;
            READS = AddressesReadPcodeArithmetic.INSTANCE;
        }
    }

    public record WatchValue(PrettyBytes bytes, TraceMemoryState state, ValueLocation location, AddressSetView reads) {
        public BigInteger toBigInteger(boolean signed) {
            return this.bytes.toBigInteger(signed);
        }

        public Address address() {
            return this.location == null ? null : this.location.getAddress();
        }

        public int length() {
            return this.bytes.length();
        }
    }

    public record PrettyBytes(boolean bigEndian, byte[] bytes) {
        private final byte[] bytes;

        public byte[] bytes() {
            return Arrays.copyOf(this.bytes, this.bytes.length);
        }

        @Override
        public String toString() {
            return "PrettyBytes[bigEndian=" + this.bigEndian + ",bytes=" + NumericUtilities.convertBytesToString((byte[])this.bytes, (String)":") + ",value=" + String.valueOf(this.toBigInteger(false)) + "]";
        }

        public String toBytesString() {
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < this.bytes.length; i += 16) {
                if (i >= 256) {
                    buf.append("\n... (count=");
                    buf.append(this.bytes.length);
                    buf.append(")");
                    break;
                }
                if (first) {
                    first = false;
                } else {
                    buf.append('\n');
                }
                int len = Math.min(16, this.bytes.length - i);
                buf.append(NumericUtilities.convertBytesToString((byte[])this.bytes, (int)i, (int)len, (String)" "));
            }
            return buf.toString();
        }

        public String toIntegerString() {
            return this.toBigInteger(false).toString();
        }

        public String collectDisplays() {
            BigInteger signed;
            boolean radixMatters;
            BigInteger unsigned = this.toBigInteger(false);
            StringBuffer sb = new StringBuffer();
            String uDec = unsigned.toString();
            sb.append(uDec);
            String uHex = unsigned.toString(16);
            boolean bl = radixMatters = !uHex.equals(uDec);
            if (radixMatters) {
                sb.append(", 0x");
                sb.append(uHex);
            }
            if (!(signed = this.toBigInteger(true)).equals(unsigned)) {
                sb.append(radixMatters ? "\n" : ", ");
                String sDec = signed.toString();
                sb.append(sDec);
                String sHex = signed.toString(16);
                if (!sHex.equals(sDec)) {
                    sb.append(", -0x");
                    sb.append(sHex.subSequence(1, sHex.length()));
                }
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrettyBytes)) {
                return false;
            }
            PrettyBytes that = (PrettyBytes)o;
            if (this.bigEndian != that.bigEndian) {
                return false;
            }
            return Arrays.equals(this.bytes, that.bytes);
        }

        public BigInteger toBigInteger(boolean signed) {
            return Utils.bytesToBigInteger((byte[])this.bytes, (int)this.bytes.length, (boolean)this.bigEndian, (boolean)signed);
        }

        public int length() {
            return this.bytes.length;
        }
    }
}

