/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import org.jdesktop.animation.timing.TimingEventListener;
import org.jdesktop.animation.timing.TimingSource;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.LinearInterpolator;

public final class Animator {
    private TimingSource timer;
    private TimingSource swingTimer;
    private TimingSourceTarget timingSourceTarget;
    private ArrayList<TimingTarget> targets = new ArrayList();
    private long startTime;
    private long currentStartTime;
    private int currentCycle = 0;
    private boolean intRepeatCount = true;
    private boolean timeToStop = false;
    private boolean hasBegun = false;
    private long pauseBeginTime = 0L;
    private boolean running = false;
    private double repeatCount = 1.0;
    private int startDelay;
    private RepeatBehavior repeatBehavior = RepeatBehavior.REVERSE;
    private EndBehavior endBehavior = EndBehavior.HOLD;
    private int duration;
    private int resolution = 20;
    private float acceleration = 0.0f;
    private float deceleration = 0.0f;
    private float startFraction = 0.0f;
    private Direction direction = Direction.FORWARD;
    private Interpolator interpolator = LinearInterpolator.getInstance();
    public static final int INFINITE = -1;

    private void validateRepeatCount(double repeatCount) {
        if (repeatCount < 1.0 && repeatCount != -1.0) {
            throw new IllegalArgumentException("repeatCount (" + repeatCount + ") cannot be <= 0");
        }
    }

    public Animator(int duration) {
        this(duration, null);
    }

    public Animator(int duration, TimingTarget target) {
        this.duration = duration;
        this.addTarget(target);
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.timer = this.swingTimer = new SwingTimingSource();
    }

    public Animator(int duration, double repeatCount, RepeatBehavior repeatBehavior, TimingTarget target) {
        this(duration, target);
        this.validateRepeatCount(repeatCount);
        this.repeatCount = repeatCount;
        this.repeatBehavior = repeatBehavior != null ? repeatBehavior : RepeatBehavior.REVERSE;
        this.intRepeatCount = Math.rint(repeatCount) == repeatCount;
    }

    public Direction getStartDirection() {
        return this.direction;
    }

    public void setStartDirection(Direction startDirection) {
        this.throwExceptionIfRunning();
        this.direction = startDirection;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.throwExceptionIfRunning();
        this.interpolator = interpolator;
    }

    public void setAcceleration(float acceleration) {
        this.throwExceptionIfRunning();
        if (acceleration < 0.0f || acceleration > 1.0f) {
            throw new IllegalArgumentException("Acceleration value cannot lie outside [0,1] range");
        }
        if (acceleration > 1.0f - this.deceleration) {
            throw new IllegalArgumentException("Acceleration value cannot be greater than (1 - deceleration)");
        }
        this.acceleration = acceleration;
    }

    public void setDeceleration(float deceleration) {
        this.throwExceptionIfRunning();
        if (deceleration < 0.0f || deceleration > 1.0f) {
            throw new IllegalArgumentException("Deceleration value cannot lie outside [0,1] range");
        }
        if (deceleration > 1.0f - this.acceleration) {
            throw new IllegalArgumentException("Deceleration value cannot be greater than (1 - acceleration)");
        }
        this.deceleration = deceleration;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public float getDeceleration() {
        return this.deceleration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(TimingTarget target) {
        if (target != null) {
            ArrayList<TimingTarget> arrayList = this.targets;
            synchronized (arrayList) {
                if (!this.targets.contains(target)) {
                    this.targets.add(target);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTarget(TimingTarget target) {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            this.targets.remove(target);
        }
    }

    private void throwExceptionIfRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while Animator is running");
        }
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        if (resolution < 0) {
            throw new IllegalArgumentException("resolution must be >= 0");
        }
        this.throwExceptionIfRunning();
        this.resolution = resolution;
        this.timer.setResolution(resolution);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.throwExceptionIfRunning();
        this.duration = duration;
    }

    public double getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(double repeatCount) {
        this.validateRepeatCount(repeatCount);
        this.throwExceptionIfRunning();
        this.repeatCount = repeatCount;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int startDelay) {
        if (startDelay < 0) {
            throw new IllegalArgumentException("startDelay (" + startDelay + ") cannot be < 0");
        }
        this.throwExceptionIfRunning();
        this.startDelay = startDelay;
        this.timer.setStartDelay(startDelay);
    }

    public RepeatBehavior getRepeatBehavior() {
        return this.repeatBehavior;
    }

    public void setRepeatBehavior(RepeatBehavior repeatBehavior) {
        this.throwExceptionIfRunning();
        this.repeatBehavior = repeatBehavior != null ? repeatBehavior : RepeatBehavior.REVERSE;
    }

    public EndBehavior getEndBehavior() {
        return this.endBehavior;
    }

    public void setEndBehavior(EndBehavior endBehavior) {
        this.throwExceptionIfRunning();
        this.endBehavior = endBehavior;
    }

    public float getStartFraction() {
        return this.startFraction;
    }

    public void setStartFraction(float startFraction) {
        if (startFraction < 0.0f || startFraction > 1.0f) {
            throw new IllegalArgumentException("initialFraction must be between 0 and 1");
        }
        this.throwExceptionIfRunning();
        this.startFraction = startFraction;
    }

    public void start() {
        this.throwExceptionIfRunning();
        this.hasBegun = false;
        this.running = true;
        this.startTime = System.nanoTime() / 1000000L + (long)this.getStartDelay();
        if (this.duration != -1 && (this.direction == Direction.FORWARD && this.startFraction > 0.0f || this.direction == Direction.BACKWARD && this.startFraction < 1.0f)) {
            float offsetFraction = this.direction == Direction.FORWARD ? this.startFraction : 1.0f - this.startFraction;
            long startDelta = (long)((float)this.duration * offsetFraction);
            this.startTime -= startDelta;
        }
        this.currentStartTime = this.startTime;
        this.timer.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.timer.stop();
        this.end();
        this.timeToStop = false;
        this.running = false;
        this.pauseBeginTime = 0L;
    }

    public void cancel() {
        this.timer.stop();
        this.timeToStop = false;
        this.running = false;
        this.pauseBeginTime = 0L;
    }

    public void pause() {
        if (this.isRunning()) {
            this.pauseBeginTime = System.nanoTime();
            this.running = false;
            this.timer.stop();
        }
    }

    public void resume() {
        if (this.pauseBeginTime > 0L) {
            long pauseDelta = (System.nanoTime() - this.pauseBeginTime) / 1000000L;
            this.startTime += pauseDelta;
            this.currentStartTime += pauseDelta;
            this.timer.start();
            this.pauseBeginTime = 0L;
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timingEvent(float fraction) {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget target = this.targets.get(i);
                target.timingEvent(fraction);
            }
        }
        if (this.timeToStop) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void begin() {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget target = this.targets.get(i);
                target.begin();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end() {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget target = this.targets.get(i);
                target.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repeat() {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget target = this.targets.get(i);
                target.repeat();
            }
        }
    }

    private float timingEventPreprocessor(float fraction) {
        if (this.acceleration != 0.0f || this.deceleration != 0.0f) {
            float oldFraction = fraction;
            float runRate = 1.0f / (1.0f - this.acceleration / 2.0f - this.deceleration / 2.0f);
            if (fraction < this.acceleration) {
                float averageRunRate = runRate * (fraction / this.acceleration) / 2.0f;
                fraction *= averageRunRate;
            } else if (fraction > 1.0f - this.deceleration) {
                float tdec = fraction - (1.0f - this.deceleration);
                float pdec = tdec / this.deceleration;
                fraction = runRate * (1.0f - this.acceleration / 2.0f - this.deceleration + tdec * (2.0f - pdec) / 2.0f);
            } else {
                fraction = runRate * (fraction - this.acceleration / 2.0f);
            }
            if (fraction < 0.0f) {
                fraction = 0.0f;
            } else if (fraction > 1.0f) {
                fraction = 1.0f;
            }
        }
        return this.interpolator.interpolate(fraction);
    }

    public long getTotalElapsedTime(long currentTime) {
        return currentTime - this.startTime;
    }

    public long getTotalElapsedTime() {
        long currentTime = System.nanoTime() / 1000000L;
        return this.getTotalElapsedTime(currentTime);
    }

    public long getCycleElapsedTime(long currentTime) {
        return currentTime - this.currentStartTime;
    }

    public long getCycleElapsedTime() {
        long currentTime = System.nanoTime() / 1000000L;
        return this.getCycleElapsedTime(currentTime);
    }

    public float getTimingFraction() {
        float fraction;
        long currentTime = System.nanoTime() / 1000000L;
        long cycleElapsedTime = this.getCycleElapsedTime(currentTime);
        long totalElapsedTime = this.getTotalElapsedTime(currentTime);
        double currentCycle = (double)totalElapsedTime / (double)this.duration;
        if (!this.hasBegun) {
            this.begin();
            this.hasBegun = true;
        }
        if (this.duration != -1 && this.repeatCount != -1.0 && currentCycle >= this.repeatCount) {
            switch (this.endBehavior) {
                case HOLD: {
                    if (this.intRepeatCount) {
                        if (this.direction == Direction.BACKWARD) {
                            fraction = 0.0f;
                            break;
                        }
                        fraction = 1.0f;
                        break;
                    }
                    fraction = Math.min(1.0f, (float)cycleElapsedTime / (float)this.duration);
                    break;
                }
                case RESET: {
                    fraction = 0.0f;
                    break;
                }
                default: {
                    fraction = 0.0f;
                }
            }
            this.timeToStop = true;
        } else if (this.duration != -1 && cycleElapsedTime > (long)this.duration) {
            long actualCycleTime = cycleElapsedTime % (long)this.duration;
            fraction = (float)actualCycleTime / (float)this.duration;
            this.currentStartTime = currentTime - actualCycleTime;
            if (this.repeatBehavior == RepeatBehavior.REVERSE) {
                boolean oddCycles;
                boolean bl = oddCycles = (int)(cycleElapsedTime / (long)this.duration) % 2 > 0;
                if (oddCycles) {
                    Direction direction = this.direction = this.direction == Direction.FORWARD ? Direction.BACKWARD : Direction.FORWARD;
                }
                if (this.direction == Direction.BACKWARD) {
                    fraction = 1.0f - fraction;
                }
            }
            this.repeat();
        } else {
            fraction = 0.0f;
            if (this.duration != -1) {
                fraction = (float)cycleElapsedTime / (float)this.duration;
                if (this.direction == Direction.BACKWARD) {
                    fraction = 1.0f - fraction;
                }
                fraction = Math.min(fraction, 1.0f);
                fraction = Math.max(fraction, 0.0f);
            }
        }
        return this.timingEventPreprocessor(fraction);
    }

    public synchronized void setTimer(TimingSource timer) {
        this.throwExceptionIfRunning();
        if (this.timer != this.swingTimer) {
            this.timer.removeEventListener(this.timingSourceTarget);
        }
        if (timer == null) {
            this.timer = this.swingTimer;
        } else {
            this.timer = timer;
            if (this.timingSourceTarget == null) {
                this.timingSourceTarget = new TimingSourceTarget();
            }
            timer.addEventListener(this.timingSourceTarget);
        }
        this.timer.setResolution(this.resolution);
        this.timer.setStartDelay(this.startDelay);
    }

    private class TimerTarget
    implements ActionListener {
        private TimerTarget() {
        }

        public void actionPerformed(ActionEvent e) {
            Animator.this.timingEvent(Animator.this.getTimingFraction());
        }
    }

    private class SwingTimingSource
    extends TimingSource {
        Timer timer;

        public SwingTimingSource() {
            this.timer = new Timer(Animator.this.resolution, new TimerTarget());
            this.timer.setInitialDelay(0);
        }

        public void start() {
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }

        public void setResolution(int resolution) {
            this.timer.setDelay(resolution);
        }

        public void setStartDelay(int delay) {
            this.timer.setInitialDelay(delay);
        }
    }

    class TimingSourceTarget
    implements TimingEventListener {
        TimingSourceTarget() {
        }

        public void timingSourceEvent(TimingSource timingSource) {
            if (Animator.this.timer == timingSource && Animator.this.running) {
                Animator.this.timingEvent(Animator.this.getTimingFraction());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepeatBehavior {
        LOOP,
        REVERSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FORWARD,
        BACKWARD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EndBehavior {
        HOLD,
        RESET;

    }
}

