/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ServerConfig {
    private TreeMap<String, String> keyValue = new TreeMap();
    private TreeSet<ConnectLine> connectSet = new TreeSet();

    public void restoreXml(XmlPullParser parser) {
        parser.start(new String[]{"serverconfig"});
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[0]);
            if (el.getName().equals("config")) {
                String key = el.getAttribute("key");
                String val = parser.end().getText();
                this.keyValue.put(key, val);
                continue;
            }
            if (el.getName().equals("connect")) {
                ConnectLine connLine = new ConnectLine();
                connLine.isMatched = false;
                connLine.restoreXml(el);
                this.connectSet.add(connLine);
                parser.end(el);
                continue;
            }
            parser.discardSubTree(el);
        }
        parser.end();
    }

    private static String stripConnectComment(String line) {
        int pos = line.indexOf(35);
        if (pos == -1) {
            pos = line.length();
        }
        for (int i = 0; i < pos; ++i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return line.substring(i, pos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patchConfig(File inFile, File outFile) throws IOException {
        TreeSet<String> alreadyemitted = new TreeSet<String>();
        ConfigLine parse = new ConfigLine();
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        FileWriter writer = new FileWriter(outFile);
        try {
            Object line;
            while ((line = reader.readLine()) != null) {
                if (((String)line).length() != 0) {
                    parse.parseUptoKey((String)line);
                    if (parse.key != null) {
                        parse.value = this.keyValue.get(parse.key);
                    }
                    if (parse.value != null) {
                        parse.skipValueParseComment((String)line);
                    }
                    if (parse.status > 0) {
                        if (!alreadyemitted.contains(parse.key)) {
                            line = parse.key + " = " + parse.value;
                            if (parse.comment.length() != 0) {
                                line = (String)line + "          " + parse.comment;
                            }
                            alreadyemitted.add(parse.key);
                        } else if (parse.status == 1) {
                            line = "#" + (String)line;
                        }
                    }
                }
                writer.write((String)line);
                writer.write(10);
            }
            for (Map.Entry<String, String> entry : this.keyValue.entrySet()) {
                if (alreadyemitted.contains(entry.getKey())) continue;
                line = entry.getKey() + " = " + entry.getValue();
                writer.write((String)line);
                writer.write(10);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patchConnect(File inFile, File outFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        FileWriter writer = new FileWriter(outFile);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String stripLine = ServerConfig.stripConnectComment(line);
                if (stripLine == null) {
                    writer.write(line);
                } else {
                    ConnectLine connLine = new ConnectLine();
                    connLine.parse(stripLine);
                    ConnectLine matchLine = this.connectSet.ceiling(connLine);
                    if (matchLine == null || 0 != matchLine.compareTo(connLine)) {
                        writer.write(35);
                        connLine.emit(writer);
                    } else {
                        matchLine.emit(writer);
                        matchLine.isMatched = true;
                    }
                }
                writer.write(10);
            }
            for (ConnectLine connLine : this.connectSet) {
                if (connLine.isMatched) continue;
                connLine.emit(writer);
                writer.write(10);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patchIdent(File inFile, File outFile, String mapName, String systemName, String roleName, boolean addUser) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        FileWriter writer = new FileWriter(outFile);
        try {
            String line;
            boolean entryIsMatched;
            boolean bl = entryIsMatched = !addUser;
            while ((line = reader.readLine()) != null) {
                IdentLine identLine = new IdentLine();
                if (identLine.parse(line)) {
                    if (identLine.matchRole(mapName, roleName)) {
                        if (!addUser) continue;
                        identLine.setSystemName(systemName);
                        entryIsMatched = true;
                    }
                    identLine.emit(writer);
                    writer.write(10);
                    continue;
                }
                writer.write(line);
                writer.write(10);
            }
            if (!entryIsMatched) {
                IdentLine identLine = new IdentLine(mapName, systemName, roleName);
                identLine.emit(writer);
                writer.write(10);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    public void addKey(String key, String value) {
        this.keyValue.put(key, value);
    }

    public String getValue(String key) {
        return this.keyValue.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanConfig(File inFile) throws IOException {
        ConfigLine parse = new ConfigLine();
        try (BufferedReader reader = new BufferedReader(new FileReader(inFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String curval;
                if (line.length() == 0) continue;
                parse.parseUptoKey(line);
                if (parse.key == null || (curval = this.keyValue.get(parse.key)) == null) continue;
                if (curval.length() != 0) {
                    throw new IOException("Multiple settings for: " + parse.key);
                }
                parse.parseValue(line);
                if (parse.status != 1) continue;
                this.keyValue.put(parse.key, parse.value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanConnect(File inFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(inFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String stripLine = ServerConfig.stripConnectComment(line);
                if (stripLine == null) continue;
                ConnectLine connLine = new ConnectLine();
                connLine.parse(stripLine);
                this.connectSet.add(connLine);
            }
        }
    }

    public String getLocalAuthentication() {
        for (ConnectLine connLine : this.connectSet) {
            if (!connLine.isLocal()) continue;
            return connLine.method;
        }
        return null;
    }

    public void setLocalAuthentication(String val, String options) {
        for (ConnectLine connLine : this.connectSet) {
            if (!connLine.isLocal()) continue;
            connLine.method = val;
            connLine.options = options;
        }
    }

    public String getHostAuthentication() {
        for (ConnectLine connLine : this.connectSet) {
            if (!connLine.type.equals("hostssl") || connLine.isLocal()) continue;
            return connLine.method;
        }
        return null;
    }

    public void setHostAuthentication(String val, String options) {
        for (ConnectLine connLine : this.connectSet) {
            if (!connLine.type.equals("hostssl") || connLine.isLocal()) continue;
            connLine.method = val;
            connLine.options = options;
        }
    }

    private static class ConnectLine
    implements Comparable<ConnectLine> {
        public String type;
        public String database;
        public String user;
        public String address;
        public String method;
        public String options;
        public boolean isMatched;

        private ConnectLine() {
        }

        @Override
        public int compareTo(ConnectLine op2) {
            int comp = this.database.compareTo(op2.database);
            if (comp != 0) {
                return comp;
            }
            comp = this.user.compareTo(op2.user);
            if (comp != 0) {
                return comp;
            }
            if (this.address == null) {
                if (op2.address != null) {
                    return -1;
                }
            } else {
                if (op2.address == null) {
                    return 1;
                }
                comp = this.address.compareTo(op2.address);
                if (comp != 0) {
                    return comp;
                }
            }
            return 0;
        }

        public boolean isLocal() {
            if (this.type.equals("local")) {
                return true;
            }
            if (this.address != null) {
                if (this.address.equals("127.0.0.1/32")) {
                    return true;
                }
                if (this.address.equals("::1/128")) {
                    return true;
                }
            }
            return false;
        }

        public void parse(String line) throws IOException {
            String[] split = line.split(" +");
            if (split.length < 4) {
                throw new IOException("Parsing error");
            }
            this.type = split[0];
            this.database = split[1];
            this.user = split[2];
            int nextPos = 3;
            if (this.type.equals("local")) {
                this.address = null;
            } else {
                this.address = split[3];
                nextPos = 4;
            }
            if (nextPos >= split.length) {
                throw new IOException("Parsing error");
            }
            this.method = split[nextPos];
            if (++nextPos >= split.length) {
                this.options = null;
                return;
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(split[nextPos]);
            ++nextPos;
            while (nextPos < split.length) {
                buffer.append(' ');
                buffer.append(split[nextPos]);
                ++nextPos;
            }
            this.options = buffer.toString();
        }

        public void restoreXml(XmlElement el) {
            this.type = el.getAttribute("type");
            this.database = el.getAttribute("db");
            this.user = el.getAttribute("user");
            this.address = el.getAttribute("addr");
            this.method = el.getAttribute("method");
            this.options = el.getAttribute("options");
        }

        public void emit(Writer writer) throws IOException {
            int i;
            writer.append(this.type);
            for (i = this.type.length(); i < 8; ++i) {
                writer.append(' ');
            }
            writer.append(this.database);
            for (i = this.database.length(); i < 16; ++i) {
                writer.append(' ');
            }
            writer.append(this.user);
            for (i = this.user.length(); i < 16; ++i) {
                writer.append(' ');
            }
            int addrLen = 0;
            if (this.address != null) {
                addrLen = this.address.length();
                writer.append(this.address);
            }
            for (int i2 = addrLen; i2 < 24; ++i2) {
                writer.append(' ');
            }
            writer.append(this.method);
            if (this.options != null) {
                writer.append(' ');
                writer.append(this.options);
            }
        }
    }

    private static class ConfigLine {
        public String key;
        public String value;
        public String comment;
        public int status;
        private int sz;
        private int pos;
        private boolean commentedkey;

        private ConfigLine() {
        }

        public void parseUptoKey(String line) {
            int tokend;
            this.key = null;
            this.value = null;
            this.comment = null;
            this.status = 0;
            this.sz = line.length();
            this.pos = 0;
            this.commentedkey = false;
            this.pos = ConfigLine.skipWhiteSpace(line, this.pos);
            if (this.pos >= this.sz) {
                return;
            }
            if (line.charAt(this.pos) == '#') {
                ++this.pos;
                this.commentedkey = true;
                this.pos = ConfigLine.skipWhiteSpace(line, this.pos);
                if (this.pos >= this.sz) {
                    return;
                }
            }
            if ((tokend = ConfigLine.scanToken(line, this.pos)) == this.pos) {
                return;
            }
            this.key = line.substring(this.pos, tokend);
            this.pos = tokend;
        }

        public void skipValueParseComment(String line) {
            this.pos = ConfigLine.skipWhiteSpace(line, this.pos);
            if (this.pos >= this.sz) {
                return;
            }
            if (line.charAt(this.pos) != '=') {
                return;
            }
            ++this.pos;
            this.comment = "";
            while (this.pos < this.sz) {
                if (line.charAt(this.pos) == '#') {
                    this.comment = line.substring(this.pos);
                    break;
                }
                ++this.pos;
            }
            this.status = this.commentedkey ? 2 : 1;
        }

        public void parseValue(String line) {
            this.pos = ConfigLine.skipWhiteSpace(line, this.pos);
            if (this.pos >= this.sz) {
                return;
            }
            if (line.charAt(this.pos) != '=') {
                return;
            }
            ++this.pos;
            this.comment = "";
            int valstart = this.pos;
            while (this.pos < this.sz) {
                if (line.charAt(this.pos) == '#') {
                    this.comment = line.substring(this.pos);
                    break;
                }
                ++this.pos;
            }
            this.value = line.substring(valstart, this.pos).trim();
            this.status = this.commentedkey ? 2 : 1;
        }

        private static int scanToken(String line, int pos) {
            char c;
            int sz = line.length();
            while (pos < sz && Character.isJavaIdentifierPart(c = line.charAt(pos))) {
                ++pos;
            }
            return pos;
        }

        private static int skipWhiteSpace(String line, int pos) {
            char c;
            int sz = line.length();
            while (pos < sz && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            return pos;
        }
    }

    private static class IdentLine {
        private String mapName;
        private String systemName;
        private boolean systemNameIsQuoted;
        private String roleName;
        private boolean roleNameIsQuoted;

        private static int skipWhiteSpace(int pos, String line) {
            char c;
            while (pos < line.length() && ((c = line.charAt(pos)) == ' ' || c == '\t')) {
                ++pos;
            }
            return pos;
        }

        private static int parseField(int pos, String line) {
            char c;
            while (pos < line.length() && (c = line.charAt(pos)) != ' ' && c != '\t') {
                ++pos;
            }
            return pos;
        }

        private static int parseDoubleQuote(int pos, String line) {
            ++pos;
            while (pos < line.length()) {
                char c = line.charAt(pos);
                if (c == '\"') {
                    ++pos;
                    break;
                }
                ++pos;
            }
            return pos;
        }

        public static boolean needsDoubleQuotes(String name) {
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isLetterOrDigit(c)) continue;
                return true;
            }
            return false;
        }

        public IdentLine() {
        }

        public IdentLine(String mName, String sysName, String rName) {
            this.mapName = mName;
            this.systemName = sysName;
            this.systemNameIsQuoted = IdentLine.needsDoubleQuotes(sysName);
            this.roleName = rName;
            this.roleNameIsQuoted = IdentLine.needsDoubleQuotes(rName);
        }

        public void setSystemName(String sysName) {
            this.systemName = sysName;
            this.systemNameIsQuoted = IdentLine.needsDoubleQuotes(sysName);
        }

        public boolean matchRole(String mName, String rName) {
            return this.mapName.equals(mName) && this.roleName.equals(rName);
        }

        public boolean parse(String line) throws IOException {
            int pos = 0;
            if ((pos = IdentLine.skipWhiteSpace(pos, line)) >= line.length()) {
                return false;
            }
            if (line.charAt(pos) == '\"') {
                throw new IOException("Bad map field in pg_ident.conf entry");
            }
            if (line.charAt(pos) == '#') {
                return false;
            }
            int endpos = IdentLine.parseField(pos, line);
            this.mapName = line.substring(pos, endpos);
            pos = IdentLine.skipWhiteSpace(endpos, line);
            if (pos >= line.length()) {
                throw new IOException("Missing system-name in pg_ident.conf entry");
            }
            if (line.charAt(pos) == '\"') {
                this.systemNameIsQuoted = true;
                endpos = IdentLine.parseDoubleQuote(pos, line);
                if (line.charAt(endpos - 1) != '\"') {
                    throw new IOException("Entry missing ending quote in pg_ident.conf");
                }
                this.systemName = line.substring(pos + 1, endpos - 1);
            } else {
                this.systemNameIsQuoted = false;
                endpos = IdentLine.parseField(pos, line);
                this.systemName = line.substring(pos, endpos);
            }
            pos = IdentLine.skipWhiteSpace(endpos, line);
            if (pos >= line.length()) {
                throw new IOException("Missing role in pg_ident.conf entry");
            }
            if (line.charAt(pos) == '\"') {
                this.roleNameIsQuoted = true;
                endpos = IdentLine.parseDoubleQuote(pos, line);
                if (line.charAt(endpos - 1) != '\"') {
                    throw new IOException("Entry missing ending quote in pg_ident.conf");
                }
                this.roleName = line.substring(pos + 1, endpos - 1);
            } else {
                this.roleNameIsQuoted = false;
                endpos = IdentLine.parseField(pos, line);
                this.roleName = line.substring(pos, endpos);
            }
            return true;
        }

        public void emit(Writer writer) throws IOException {
            int i;
            writer.write(this.mapName);
            for (i = this.mapName.length(); i < 15; ++i) {
                writer.write(32);
            }
            writer.write(32);
            if (this.systemNameIsQuoted) {
                writer.write(34);
            }
            writer.write(this.systemName);
            if (this.systemNameIsQuoted) {
                writer.write(34);
            }
            for (i = this.systemName.length() + (this.systemNameIsQuoted ? 2 : 0); i < 23; ++i) {
                writer.write(32);
            }
            writer.write(32);
            if (this.roleNameIsQuoted) {
                writer.write(34);
            }
            writer.write(this.roleName);
            if (this.roleNameIsQuoted) {
                writer.write(34);
            }
        }
    }
}

