/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.breakpoint;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointManager;
import ghidra.trace.model.breakpoint.TraceBreakpointSpec;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceBreakpointManager
implements TraceBreakpointManager,
DBTraceManager {
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceObjectManager objectManager;

    public DBTraceBreakpointManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, DBTraceObjectManager objectManager) throws VersionException, IOException {
        this.lock = lock;
        this.trace = trace;
        this.objectManager = objectManager;
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
    }

    @Override
    public TraceBreakpointLocation addBreakpoint(String path, Lifespan lifespan, AddressRange range, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        return this.objectManager.addBreakpoint(path, lifespan, range, threads, kinds, enabled, comment);
    }

    @Override
    public Collection<? extends TraceBreakpointSpec> getAllBreakpointSpecifications() {
        return this.objectManager.getAllObjects(TraceBreakpointSpec.class);
    }

    @Override
    public Collection<? extends TraceBreakpointLocation> getAllBreakpointLocations() {
        return this.objectManager.getAllObjects(TraceBreakpointLocation.class);
    }

    @Override
    public Collection<? extends TraceBreakpointSpec> getBreakpointSpecificationsByPath(String path) {
        return this.objectManager.getObjectsByPath(path, TraceBreakpointSpec.class);
    }

    @Override
    public Collection<? extends TraceBreakpointLocation> getBreakpointLocationsByPath(String path) {
        return this.objectManager.getObjectsByPath(path, TraceBreakpointLocation.class);
    }

    @Override
    public TraceBreakpointLocation getPlacedBreakpointByPath(long snap, String path) {
        return this.objectManager.getObjectByPath(snap, path, TraceBreakpointLocation.class);
    }

    @Override
    public Collection<? extends TraceBreakpointLocation> getBreakpointsAt(long snap, Address address) {
        return this.objectManager.getObjectsContaining(snap, address, "_range", TraceBreakpointLocation.class);
    }

    @Override
    public Collection<? extends TraceBreakpointLocation> getBreakpointsIntersecting(Lifespan span, AddressRange range) {
        return this.objectManager.getObjectsIntersecting(span, range, "_range", TraceBreakpointLocation.class);
    }
}

