/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph.panel.model.row;

import datagraph.data.graph.panel.model.row.DataRowObject;
import java.util.ArrayList;
import java.util.List;

public class DataRowObjectCache {
    private static final int MAX_CACHE_SIZE = 300;
    List<DataRowObject> cachedRows = new ArrayList<DataRowObject>();
    int startIndex = 0;

    public boolean contains(int rowIndex) {
        int cacheIndex = rowIndex - this.startIndex;
        return cacheIndex >= 0 && cacheIndex < this.cachedRows.size();
    }

    public DataRowObject getDataRow(int rowIndex) {
        return this.cachedRows.get(rowIndex - this.startIndex);
    }

    public void putData(int rowIndex, DataRowObject row) {
        if (rowIndex != this.startIndex + this.cachedRows.size() || this.cachedRows.size() > 300) {
            this.clear();
            this.startIndex = rowIndex;
        }
        this.cachedRows.add(row);
    }

    public void clear() {
        this.startIndex = 0;
        this.cachedRows.clear();
    }
}

