/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.catacombae.hfsexplorer.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNameTools {
    private static HashSet<String> reservedWindowsFilenames = null;

    public static String autoRenameIllegalFilename(String filename, File outDir, boolean isDirectory) {
        int c;
        int i;
        int substituteChar = 95;
        if (FileNameTools.isReservedWindowsFilename(filename)) {
            filename = FileNameTools.getSafeRandomFilename("hfsx");
        }
        char[] filenameChars = filename.toCharArray();
        for (i = 0; i < filenameChars.length; ++i) {
            c = Util.unsign(filenameChars[i]);
            if (c < 32 || c == 127 || c >= 128 && c <= 159) {
                filenameChars[i] = 95;
                continue;
            }
            if (!FileNameTools.isIllegalWindowsCharacter(c)) continue;
            filenameChars[i] = 95;
        }
        for (i = filenameChars.length - 1; i >= 0 && ((c = filenameChars[i]) == 32 || c == 46); --i) {
            filenameChars[i] = 95;
        }
        filename = new String(filenameChars);
        String createdFilename = FileNameTools.tryCreate(filename, outDir, isDirectory);
        if (createdFilename != null) {
            return createdFilename;
        }
        if (filename.length() > 240 && (createdFilename = FileNameTools.tryCreate(filename = filename.substring(0, 240), outDir, isDirectory)) != null) {
            return createdFilename;
        }
        if (filename.length() > 27 && (createdFilename = FileNameTools.tryCreate(filename = filename.substring(0, 27), outDir, isDirectory)) != null) {
            return createdFilename;
        }
        if (filename.length() > 8 && (createdFilename = FileNameTools.tryCreate(filename = filename.substring(0, 8), outDir, isDirectory)) != null) {
            return createdFilename;
        }
        filename = FileNameTools.getSafeRandomFilename("hfsx");
        createdFilename = FileNameTools.tryCreate(filename, outDir, isDirectory);
        if (createdFilename != null) {
            return createdFilename;
        }
        return null;
    }

    public static String getSafeRandomFilename(String prefix) {
        int suffixLength = 8 - prefix.length();
        if (suffixLength <= 0) {
            return prefix.substring(0, 8);
        }
        int suffixBase = 1;
        for (int i = 0; i < suffixLength; ++i) {
            suffixBase *= 10;
        }
        String suffixString = Integer.toString((int)(Math.random() * (double)(--suffixBase)));
        return prefix + suffixString;
    }

    public static String tryCreate(String filename, File outDir, boolean asDirectory) {
        String originalFilename = filename;
        File f = new File(outDir, filename);
        int limit = 999;
        int i = 0;
        while (f.exists() && i < 999) {
            filename = originalFilename + "." + i++;
            f = new File(outDir, filename);
        }
        if (f.exists()) {
            return null;
        }
        try {
            if (asDirectory) {
                if (f.mkdir()) {
                    f.delete();
                    return filename;
                }
            } else if (f.createNewFile()) {
                f.delete();
                return filename;
            }
        }
        catch (IOException e) {
            System.err.println("IOException while trying to create \"" + f.getAbsolutePath() + "\" as " + (asDirectory ? "directory" : "file") + ":");
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isIllegalWindowsCharacter(char c) {
        return FileNameTools.isIllegalWindowsCharacter(Util.unsign(c));
    }

    private static boolean isIllegalWindowsCharacter(int c) {
        if (c < 32) {
            return true;
        }
        switch (c) {
            case 34: 
            case 42: 
            case 47: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 92: 
            case 124: {
                return true;
            }
        }
        return false;
    }

    public static boolean isReservedWindowsFilename(String filename) {
        if (reservedWindowsFilenames == null) {
            reservedWindowsFilenames = FileNameTools.buildReservedWindowsFilenames();
        }
        if (reservedWindowsFilenames.contains(filename)) {
            return true;
        }
        if (filename.charAt(4) == '.' && reservedWindowsFilenames.contains(filename.substring(0, 4))) {
            return true;
        }
        return filename.charAt(3) == '.' && reservedWindowsFilenames.contains(filename.substring(0, 3));
    }

    public static HashSet<String> buildReservedWindowsFilenames() {
        int i;
        HashSet<String> result = new HashSet<String>();
        result.add("CON");
        result.add("PRN");
        result.add("AUX");
        result.add("NUL");
        for (i = 0; i < 10; ++i) {
            result.add("COM" + i);
        }
        for (i = 0; i < 10; ++i) {
            result.add("LPT" + i);
        }
        result.add("CLOCK$");
        return result;
    }
}

