/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBRecord;
import ghidra.feature.vt.api.db.VTMatchTagDBAdapter;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import java.io.IOException;

public class VTMatchTagDB
extends DatabaseObject
implements VTMatchTag {
    private VTSessionDB sessionDB;
    private DBRecord record;

    VTMatchTagDB(VTSessionDB sessionDB, DBObjectCache<VTMatchTagDB> cache, DBRecord record) {
        super(cache, record.getKey());
        this.sessionDB = sessionDB;
        this.record = record;
    }

    public String toString() {
        return this.getName();
    }

    void setRecord(DBRecord rec) {
        if (rec.getKey() != this.key) {
            throw new IllegalArgumentException("Key mismatch");
        }
        this.record = rec;
    }

    protected boolean refresh() {
        DBRecord rec = null;
        try {
            rec = this.sessionDB.getTagRecord(this.key);
        }
        catch (IOException e) {
            this.sessionDB.dbError(e);
        }
        if (rec == null) {
            return false;
        }
        this.record = rec;
        return true;
    }

    DBRecord getRecord() {
        return this.checkIsValid() ? this.record : null;
    }

    @Override
    public String getName() {
        return this.record.getString(VTMatchTagDBAdapter.ColumnDescription.TAG_NAME_COL.column());
    }

    @Override
    public int compareTo(VTMatchTag otherTag) {
        return this.getName().compareTo(otherTag.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VTMatchTag)) {
            return false;
        }
        VTMatchTag other = (VTMatchTag)obj;
        return this.getName().equals(other.getName());
    }
}

