/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import java.time.LocalDate;
import javax.swing.AbstractSpinnerModel;

public class LocalDateSpinnerModel
extends AbstractSpinnerModel {
    private LocalDate currentValue;
    private int calendarField;
    private LocalDate minDate;
    private LocalDate maxDate;

    public LocalDateSpinnerModel(LocalDate value, LocalDate minDate, LocalDate maxDate, int calendarField) {
        this.currentValue = value;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.checkIsValidCalendarField(calendarField);
        this.calendarField = calendarField;
    }

    @Override
    public Object getValue() {
        return this.currentValue;
    }

    @Override
    public void setValue(Object value) {
        if (value.equals(this.currentValue)) {
            return;
        }
        this.currentValue = (LocalDate)value;
        this.fireStateChanged();
    }

    @Override
    public Object getNextValue() {
        LocalDate nextDate = null;
        switch (this.calendarField) {
            case 5: {
                nextDate = this.currentValue.plusDays(1L);
                break;
            }
            case 2: {
                nextDate = this.currentValue.plusMonths(1L);
                break;
            }
            case 1: {
                nextDate = this.currentValue.plusYears(1L);
            }
        }
        if (this.minDate != null && this.minDate.compareTo(nextDate) < 0) {
            return nextDate;
        }
        return null;
    }

    @Override
    public Object getPreviousValue() {
        LocalDate previousDate = null;
        switch (this.calendarField) {
            case 5: {
                previousDate = this.currentValue.minusDays(1L);
                break;
            }
            case 2: {
                previousDate = this.currentValue.minusMonths(1L);
                break;
            }
            case 1: {
                previousDate = this.currentValue.minusYears(1L);
            }
        }
        if (this.minDate != null && this.minDate.compareTo(previousDate) < 0) {
            return previousDate;
        }
        return null;
    }

    public LocalDate getMinDate() {
        return this.minDate;
    }

    public LocalDate getMaxDate() {
        return this.maxDate;
    }

    public void setCalendarField(int calendarField) {
        this.checkIsValidCalendarField(calendarField);
        if (calendarField != this.calendarField) {
            this.calendarField = calendarField;
            this.fireStateChanged();
        }
    }

    private void checkIsValidCalendarField(int calField) {
        switch (calField) {
            case 1: 
            case 2: 
            case 5: {
                return;
            }
        }
        throw new IllegalArgumentException("invalid calendarField");
    }

    public LocalDate getDate() {
        return this.currentValue;
    }
}

