/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.columnfilter;

import docking.DockingWindowManager;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import ghidra.framework.options.PreferenceState;
import ghidra.framework.options.SaveState;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.jdom.Element;

public class ColumnFilterSaveManager<R> {
    private static final String COLUMN_FILTER_STATE = "COLUMN_FILTER_STATE";
    private List<ColumnBasedTableFilter<R>> filters = new ArrayList<ColumnBasedTableFilter<R>>();
    private String preferenceKey;
    private DockingWindowManager dockingWindowManager;

    public ColumnFilterSaveManager(String tablePreferenceKey, JTable table, RowObjectTableModel<R> model, Object dataSource) {
        this.preferenceKey = tablePreferenceKey + ".FilterExtension";
        this.loadFromPreferences(table, model, dataSource);
    }

    public void addFilter(ColumnBasedTableFilter<R> filter) {
        this.filters.add(filter);
    }

    public void removeFilter(ColumnBasedTableFilter<R> filter) {
        this.filters.remove(filter);
    }

    public void save() {
        SaveState saveState = new SaveState("COlUMN_FILTERS");
        saveState.putInt("NUM_FILTERS", this.filters.size());
        for (int i = 0; i < this.filters.size(); ++i) {
            saveState.putXmlElement("FILTER_STATE_" + i, this.filters.get(i).save().saveToXml());
        }
        PreferenceState preferenceState = new PreferenceState();
        preferenceState.putXmlElement(COLUMN_FILTER_STATE, saveState.saveToXml());
        if (this.dockingWindowManager == null) {
            return;
        }
        this.dockingWindowManager.putPreferenceState(this.preferenceKey, preferenceState);
    }

    public List<ColumnBasedTableFilter<R>> getSavedFilters() {
        return this.filters;
    }

    private void loadFromPreferences(JTable table, RowObjectTableModel<R> model, Object dataSource) {
        this.dockingWindowManager = DockingWindowManager.getInstance(table);
        if (this.dockingWindowManager == null) {
            return;
        }
        PreferenceState preferenceState = this.dockingWindowManager.getPreferenceState(this.preferenceKey);
        if (preferenceState != null) {
            Element xmlElement = preferenceState.getXmlElement(COLUMN_FILTER_STATE);
            this.restoreFromXML(xmlElement, model, dataSource);
        }
    }

    private void restoreFromXML(Element element, RowObjectTableModel<R> model, Object dataSource) {
        SaveState saveState = new SaveState(element);
        int numFilters = saveState.getInt("NUM_FILTERS", 0);
        for (int i = 0; i < numFilters; ++i) {
            Element child = saveState.getXmlElement("FILTER_STATE_" + i);
            SaveState childState = new SaveState(child);
            ColumnBasedTableFilter<R> filter = new ColumnBasedTableFilter<R>(model);
            try {
                filter.restore(childState, dataSource);
                this.filters.add(filter);
                continue;
            }
            catch (Exception e) {
                Msg.warn((Object)this, (Object)"Can't load filter");
            }
        }
    }

    public boolean containsFilterWithName(String name) {
        for (ColumnBasedTableFilter<R> columnTableFilter : this.filters) {
            if (!name.equals(columnTableFilter.getName())) continue;
            return true;
        }
        return false;
    }
}

