/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatree.DataTreeNode;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class DomainFolderNode
extends DataTreeNode {
    private static final Icon ENABLED_OPEN_FOLDER = DomainFolder.OPEN_FOLDER_ICON;
    private static final Icon ENABLED_CLOSED_FOLDER = DomainFolder.CLOSED_FOLDER_ICON;
    private static final Icon DISABLED_OPEN_FOLDER = ResourceManager.getDisabledIcon((Icon)ENABLED_OPEN_FOLDER);
    private static final Icon DISABLED_CLOSED_FOLDER = ResourceManager.getDisabledIcon((Icon)ENABLED_CLOSED_FOLDER);
    private DomainFolder domainFolder;
    private DomainFileFilter filter;
    private String toolTipText;
    private boolean isEditable;

    DomainFolderNode(DomainFolder domainFolder, DomainFileFilter filter) {
        this.domainFolder = domainFolder;
        this.filter = filter;
        if (domainFolder != null) {
            this.setToolTipText();
            this.isEditable = domainFolder.isInWritableProject();
        }
    }

    public boolean isAutoExpandPermitted() {
        return !this.domainFolder.isLinked();
    }

    public DomainFolder getDomainFolder() {
        return this.domainFolder;
    }

    @Override
    public String getPathname() {
        return this.domainFolder.getPathname();
    }

    public boolean isLeaf() {
        return false;
    }

    public Icon getIcon(boolean expanded) {
        if (this.isCut()) {
            return expanded ? DISABLED_OPEN_FOLDER : DISABLED_CLOSED_FOLDER;
        }
        return expanded ? ENABLED_OPEN_FOLDER : ENABLED_CLOSED_FOLDER;
    }

    public String getName() {
        return this.domainFolder.getName();
    }

    public String toString() {
        return this.getName();
    }

    public String getToolTip() {
        return this.toolTipText;
    }

    private void setToolTipText() {
        String newToolTipText = this.domainFolder instanceof LinkedDomainFolder ? this.domainFolder.toString() : this.domainFolder.getPathname();
        this.toolTipText = HTMLUtilities.toLiteralHTML((String)newToolTipText, (int)0);
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        return DomainFolderNode.generateChildren(this.domainFolder, this.filter, monitor);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainFolderNode node = (DomainFolderNode)obj;
        return this.domainFolder.equals(node.domainFolder);
    }

    @Override
    public int hashCode() {
        return this.domainFolder.hashCode();
    }

    public DomainFileFilter getDomainFileFilter() {
        return this.filter;
    }

    @Override
    public int compareTo(GTreeNode node) {
        return DATA_NODE_SORT_COMPARATOR.compare(this, node);
    }

    public void valueChanged(Object newValue) {
        if (newValue.equals(this.getName())) {
            return;
        }
        if (newValue instanceof String) {
            try {
                this.domainFolder.setName((String)newValue);
            }
            catch (InvalidNameException e) {
                Msg.showError((Object)this, (Component)this.getTree(), (String)"Rename Failed", (Object)("Invalid name: " + String.valueOf(newValue)));
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)this.getTree(), (String)"Rename Failed", (Object)e.getMessage());
            }
        }
    }

    @Override
    public GTreeNode getChild(String name, DataTreeNode.NodeType type) {
        return DomainFolderNode.getChild(this.children(), name, type);
    }

    @Override
    public ProjectData getProjectData() {
        return this.domainFolder.getProjectData();
    }
}

