/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.action.MenuData;
import generic.theme.GIcon;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.datatable.FrontendProjectTreeAction;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;

public class ProjectRepoConnectAction
extends FrontendProjectTreeAction {
    private static final Icon CONNECT_ICON = new GIcon("icon.frontend.project.connected");
    private FrontEndPlugin plugin;

    public ProjectRepoConnectAction(FrontEndPlugin plugin, String group) {
        super("Connect Shared Repository", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Connect Shared Repository"}, CONNECT_ICON, group));
        this.setHelpLocation(new HelpLocation("VersionControl", "ConnectToServer"));
    }

    protected void actionPerformed(ProjectDataContext context) {
        RepositoryAdapter repository = this.getDisconnectedRepository(context);
        if (repository != null) {
            try {
                repository.connect();
            }
            catch (NotConnectedException notConnectedException) {
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"Repository Connection", (Component)this.plugin.getTool().getToolFrame());
            }
        }
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataContext context) {
        return this.getDisconnectedRepository(context) != null;
    }

    private RepositoryAdapter getDisconnectedRepository(ProjectDataContext context) {
        if (!(context.getComponent() instanceof DataTree)) {
            return null;
        }
        if (context.getFolderCount() != 1 || context.getFileCount() != 0) {
            return null;
        }
        DomainFolder domainFolder = context.getSelectedFolders().get(0);
        if (domainFolder.getParent() != null) {
            return null;
        }
        ProjectData projectData = domainFolder.getProjectData();
        if (projectData.getProjectLocator().isTransient()) {
            return null;
        }
        RepositoryAdapter repository = projectData.getRepository();
        if (repository != null && !repository.isConnected()) {
            return repository;
        }
        return null;
    }
}

