/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import generic.util.FileLocker;
import generic.util.LockFactory;
import ghidra.framework.model.ProjectLocator;
import java.io.File;

class ProjectLock {
    private final File lockFile;
    private FileLocker locker;

    public ProjectLock(ProjectLocator projectLocator) {
        this.lockFile = projectLocator.getProjectLockFile();
        this.locker = LockFactory.createFileLocker((File)this.lockFile);
    }

    boolean lock() {
        return this.locker.lock();
    }

    boolean forceLock() {
        return this.locker.forceLock();
    }

    boolean canForceLock() {
        return this.locker.canForceLock();
    }

    void release() {
        this.locker.release();
    }

    boolean isLocked() {
        return this.locker.isLocked();
    }

    String getExistingLockFileInformation() {
        return this.locker.getExistingLockFileInformation();
    }
}

