/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CvRecord
implements StructConverter {
    public static final String NAME = "MINIDUMP_CV_RECORD";
    private int pdbFormat;
    private byte[] pdbSigGUID = new byte[16];
    private int pdbAge;
    private byte[] pdbName;
    private DumpFileReader reader;
    private long index;
    private int nameLength;

    CvRecord(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        int i;
        this.reader.setPointerIndex(this.index);
        this.setPdbFormat(this.reader.readNextInt());
        for (i = 0; i < this.pdbSigGUID.length; ++i) {
            this.setPdbSigGUID(this.reader.readNextByte(), i);
        }
        this.setPdbAge(this.reader.readNextInt());
        this.nameLength = CvRecord.getNameLength(this.reader, this.reader.getPointerIndex());
        this.pdbName = new byte[this.nameLength];
        for (i = 0; i < this.nameLength; ++i) {
            this.setPdbName(this.reader.readNextByte(), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "PdbFormat", null);
        ArrayDataType adt = new ArrayDataType(BYTE, 16, 1);
        struct.add((DataType)adt, 16, "PdbSigGUID", null);
        struct.add(DWORD, 4, "PdbAge", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getPdbFormat() {
        return this.pdbFormat;
    }

    public void setPdbFormat(int pdbFormat) {
        this.pdbFormat = pdbFormat;
    }

    public byte[] getPdbSigGUID() {
        return this.pdbSigGUID;
    }

    public void setPdbSigGUID(byte b, int index) {
        this.pdbSigGUID[index] = b;
    }

    public int getPdbAge() {
        return this.pdbAge;
    }

    public void setPdbAge(int pdbAge) {
        this.pdbAge = pdbAge;
    }

    public byte[] getPdbName() {
        return this.pdbName;
    }

    public void setPdbName(byte b, int index) {
        this.pdbName[index] = b;
    }

    public static int getNameLength(DumpFileReader r, long pos) throws IOException {
        int i = 0;
        while (r.readNextByte() != 0) {
            ++i;
        }
        r.setPointerIndex(pos);
        return i;
    }
}

